/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.group;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.Interval;

public abstract class IntervalList
extends ArrayList<Interval> {
    protected ColumnGroup columnGroup = null;
    protected String intervalType = null;
    protected Object minValue = null;
    protected Object maxValue = null;

    public IntervalList(ColumnGroup columnGroup) {
        this.columnGroup = columnGroup;
        this.intervalType = columnGroup.getIntervalSize();
    }

    public ColumnGroup getColumnGroup() {
        return this.columnGroup;
    }

    public String getIntervalType() {
        return this.intervalType;
    }

    public void setIntervalType(String intervalType) {
        this.intervalType = intervalType;
    }

    public Object getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Object minValue) {
        this.minValue = minValue;
    }

    public Object getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Object maxValue) {
        this.maxValue = maxValue;
    }

    public IntervalList indexValues(List<Object> values, List<Integer> rows) {
        if (rows == null) {
            for (int row = 0; row < values.size(); ++row) {
                Object value = values.get(row);
                this.indexValue(value, row);
            }
        } else {
            for (Integer row : rows) {
                Object value = values.get(row);
                this.indexValue(value, row);
            }
        }
        return this;
    }

    public void indexValue(Object value, int row) {
        Interval interval;
        if (value != null && (interval = this.locateInterval(value)) != null) {
            interval.getRows().add(row);
        }
    }

    public abstract Interval locateInterval(Object var1);
}

