/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.authoring;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.kie.workbench.common.forms.data.modeller.service.ext.ModelReaderService;
import org.kie.workbench.common.forms.editor.model.FormModelSynchronizationResult;
import org.kie.workbench.common.forms.editor.service.backend.FormModelHandler;
import org.kie.workbench.common.forms.editor.service.backend.FormModelHandlerManager;
import org.kie.workbench.common.forms.editor.service.shared.ModuleFormFinderService;
import org.kie.workbench.common.forms.editor.service.shared.model.FormModelSynchronizationUtil;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.AbstractBPMNFormGeneratorService;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.GenerationContext;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.authoring.Authoring;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.model.FormModel;
import org.kie.workbench.common.forms.service.shared.FieldManager;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.kie.workbench.common.forms.services.backend.util.UIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@Authoring
@Dependent
public class BPMNVFSFormDefinitionGeneratorService
extends AbstractBPMNFormGeneratorService<org.uberfire.backend.vfs.Path> {
    private static final Logger logger = LoggerFactory.getLogger(BPMNVFSFormDefinitionGeneratorService.class);
    private FormModelHandlerManager formModelHandlerManager;
    private ModuleFormFinderService formFinderService;
    private FormDefinitionSerializer formSerializer;
    private IOService ioService;
    private CommentedOptionFactory commentedOptionFactory;
    private FormModelSynchronizationUtil formModelSynchronizationUtil;

    @Inject
    public BPMNVFSFormDefinitionGeneratorService(FieldManager fieldManager, ModelReaderService<org.uberfire.backend.vfs.Path> modelReaderService, FormModelHandlerManager formModelHandlerManager, ModuleFormFinderService formFinderService, FormDefinitionSerializer formSerializer, @Named(value="ioStrategy") IOService ioService, CommentedOptionFactory commentedOptionFactory, FormModelSynchronizationUtil formModelSynchronizationUtil) {
        super(modelReaderService, fieldManager);
        this.formModelHandlerManager = formModelHandlerManager;
        this.formFinderService = formFinderService;
        this.formSerializer = formSerializer;
        this.ioService = ioService;
        this.commentedOptionFactory = commentedOptionFactory;
        this.formModelSynchronizationUtil = formModelSynchronizationUtil;
    }

    @Override
    public FormDefinition createRootFormDefinition(GenerationContext<org.uberfire.backend.vfs.Path> context) {
        FormDefinition form;
        FormModelHandler modelHandler = this.formModelHandlerManager.getFormModelHandler(context.getFormModel().getClass());
        modelHandler.init((FormModel)context.getFormModel(), context.getSource());
        Path kiePath = Paths.convert((org.uberfire.backend.vfs.Path)context.getSource());
        logger.info("Started form generation for '{}'", (Object)kiePath);
        if (this.ioService.exists(kiePath)) {
            form = this.formSerializer.deserialize(this.ioService.readAllString(kiePath));
            logger.warn("Already exists form '{}'. Synchronizing form fields:", (Object)kiePath);
            FormModelSynchronizationResult synchronizationResult = modelHandler.synchronizeFormModelProperties(form.getModel(), context.getFormModel().getProperties());
            this.formModelSynchronizationUtil.init(form, synchronizationResult);
            if (synchronizationResult.hasRemovedProperties()) {
                logger.warn("Process/Task has removed variables, checking fields:");
                this.formModelSynchronizationUtil.fixRemovedFields();
            }
            if (synchronizationResult.hasConflicts()) {
                logger.warn("Process/Task has some variables which type has changed. Checking fields:");
                this.formModelSynchronizationUtil.resolveConflicts();
            }
            if (synchronizationResult.hasNewProperties()) {
                logger.warn("Process/Task has new variables. Adding them to form:");
                this.formModelSynchronizationUtil.addNewFields(arg_0 -> ((FieldManager)this.fieldManager).getDefinitionByModelProperty(arg_0));
            }
            form.setModel((FormModel)context.getFormModel());
        } else {
            form = new FormDefinition((FormModel)context.getFormModel());
            form.setId(UIDGenerator.generateUID());
            form.setName(context.getSource().getFileName());
            form.getFields().addAll(context.getFormModel().getProperties().stream().map(arg_0 -> ((FieldManager)this.fieldManager).getDefinitionByModelProperty(arg_0)).collect(Collectors.toList()));
        }
        form.setModel((FormModel)context.getFormModel());
        return form;
    }

    @Override
    protected FormDefinition createModelFormDefinition(String modelType, GenerationContext<org.uberfire.backend.vfs.Path> context) {
        FormDefinition form = super.createModelFormDefinition(modelType, context);
        Path path = Paths.convert((org.uberfire.backend.vfs.Path)context.getSource()).getParent().resolve(form.getName() + "." + "frm");
        this.ioService.write(path, this.formSerializer.serialize(form), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption("Automatically generated form")});
        return form;
    }

    @Override
    protected void log(String message, Exception ex) {
        logger.warn(message, (Throwable)ex);
    }

    @Override
    protected FormDefinition findFormDefinitionForModelType(String modelType, GenerationContext<org.uberfire.backend.vfs.Path> context) {
        FormDefinition form = super.findFormDefinitionForModelType(modelType, context);
        if (form != null) {
            return form;
        }
        List foundForms = this.formFinderService.findFormsForType(modelType, context.getSource());
        Optional<FormDefinition> validForm = foundForms.stream().filter(formDefinition -> !formDefinition.getFields().isEmpty()).findFirst();
        return validForm.orElse(foundForms.stream().findFirst().orElse(null));
    }

    @Override
    protected boolean supportsEmptyNestedForms() {
        return true;
    }
}

