/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.jbpm.server.service.impl;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.util.Bpmn2ResourceFactoryImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.util.DroolsResourceFactoryImpl;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.api.io.ResourceType;
import org.kie.workbench.common.forms.jbpm.model.authoring.JBPMProcessModel;
import org.kie.workbench.common.forms.jbpm.model.authoring.process.BusinessProcessFormModel;
import org.kie.workbench.common.forms.jbpm.model.authoring.task.TaskFormModel;
import org.kie.workbench.common.forms.jbpm.server.service.BPMNFormModelGenerator;
import org.kie.workbench.common.forms.jbpm.service.shared.BPMFinderService;
import org.kie.workbench.common.forms.services.backend.util.VFSScanner;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@Service
@Dependent
public class BPMFinderServiceImpl
implements BPMFinderService {
    private static final Logger logger = LoggerFactory.getLogger(BPMFinderServiceImpl.class);
    private IOService ioService;
    private KieModuleService moduleService;
    private BPMNFormModelGenerator bpmnFormModelGenerator;

    @Inject
    public BPMFinderServiceImpl(@Named(value="ioStrategy") IOService ioService, KieModuleService moduleService, BPMNFormModelGenerator bpmnFormModelGenerator) {
        this.ioService = ioService;
        this.moduleService = moduleService;
        this.bpmnFormModelGenerator = bpmnFormModelGenerator;
    }

    public List<JBPMProcessModel> getAvailableProcessModels(org.uberfire.backend.vfs.Path path) {
        return this.findModels(path, definitions -> true).collect(Collectors.toList());
    }

    public JBPMProcessModel getModelForProcess(String processId, org.uberfire.backend.vfs.Path path) {
        return this.findModels(path, definitions -> this.matchProcessId((Definitions)definitions, processId)).findFirst().orElse(null);
    }

    private boolean matchProcessId(Definitions definitions, String processId) {
        if (definitions == null) {
            return false;
        }
        Process process = this.bpmnFormModelGenerator.getProcess(definitions);
        if (process == null) {
            return false;
        }
        return process.getId().equals(processId);
    }

    private Stream<JBPMProcessModel> findModels(org.uberfire.backend.vfs.Path path, Predicate<Definitions> filter) {
        org.uberfire.backend.vfs.Path rootPath = ((KieModule)this.moduleService.resolveModule(path)).getRootPath();
        return VFSScanner.scan((IOService)this.ioService, (Path)Paths.convert((org.uberfire.backend.vfs.Path)rootPath), (Collection)ResourceType.getResourceType((String)"BPMN2").getAllExtensions(), this::toDefinitions, filter).stream().filter(Objects::nonNull).map(VFSScanner.ScanResult::getResource).map(definitions -> this.parseToModel((Definitions)definitions, path));
    }

    private JBPMProcessModel parseToModel(Definitions definitions, org.uberfire.backend.vfs.Path path) {
        BusinessProcessFormModel processFormModel = this.bpmnFormModelGenerator.generateProcessFormModel(definitions, path);
        List<TaskFormModel> taskModels = this.bpmnFormModelGenerator.generateTaskFormModels(definitions, path);
        return new JBPMProcessModel(processFormModel, taskModels);
    }

    private Definitions toDefinitions(InputStream in) {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new DroolsResourceFactoryImpl());
            resourceSet.getPackageRegistry().put((Object)"http://www.jboss.org/drools", (Object)DroolsPackage.eINSTANCE);
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new Bpmn2ResourceFactoryImpl());
            resourceSet.getPackageRegistry().put((Object)"http://www.omg.org/spec/BPMN/20100524/MODEL", (Object)Bpmn2Package.eINSTANCE);
            XMLResource outResource = (XMLResource)resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
            outResource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
            outResource.setEncoding("UTF-8");
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", "UTF-8");
            outResource.load(in, options);
            DocumentRoot root = (DocumentRoot)outResource.getContents().get(0);
            return root.getDefinitions();
        }
        catch (Exception ex) {
            logger.warn("Cannot parse definitions due to", (Throwable)ex);
            return null;
        }
    }
}

