/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service.storage.scoped.impl;

import java.text.MessageFormat;
import java.util.Base64;
import java.util.Collection;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefinition;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.experimental.service.storage.scoped.ExperimentalStorageScope;
import org.uberfire.experimental.service.storage.scoped.impl.AbstractScopedExperimentalFeaturesStorage;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.rpc.SessionInfo;

@Dependent
public class UserExperimentalFeaturesStorageImpl
extends AbstractScopedExperimentalFeaturesStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserExperimentalFeaturesStorageImpl.class);
    public static final String USER_FOLDER_ROOT = "/experimental/users";
    public static final String USER_FOLDER = "/experimental/users/{0}/.experimental";

    @Inject
    public UserExperimentalFeaturesStorageImpl(SessionInfo sessionInfo, @Named(value="configIO") IOService ioService, ExperimentalFeatureDefRegistry defRegistry) {
        super(sessionInfo, ioService, defRegistry);
    }

    @Override
    public void init(FileSystem fileSystem) {
        super.init(fileSystem);
        this.checkStoragePath();
    }

    private void checkStoragePath() {
        Path path = this.fileSystem.getPath(USER_FOLDER_ROOT, new String[0]);
        if (!this.ioService.exists(path)) {
            this.ioService.createDirectory(path, new FileAttribute[0]);
        }
    }

    @Override
    protected Collection<ExperimentalFeatureDefinition> getSupportedDefinitions() {
        return this.defRegistry.getUserFeatures();
    }

    @Override
    public Collection<ExperimentalFeatureImpl> getFeatures() {
        return this.readFeatures();
    }

    @Override
    public String getStoragePath() {
        return MessageFormat.format(USER_FOLDER, this.getUserId());
    }

    private String getUserId() {
        return UserExperimentalFeaturesStorageImpl.encode(this.sessionInfo.getIdentity().getIdentifier());
    }

    @Override
    protected Logger log() {
        return LOGGER;
    }

    @Override
    public ExperimentalStorageScope getScope() {
        return ExperimentalStorageScope.USER;
    }

    public static String encode(String folderName) {
        return new String(Base64.getEncoder().encode(folderName.getBytes()));
    }
}

