/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.json;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONBuffer;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONMessages;
import com.unboundid.util.json.JSONNull;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONObject
extends JSONValue {
    public static final JSONObject EMPTY_OBJECT = new JSONObject(Collections.<String, JSONValue>emptyMap());
    private static final long serialVersionUID = -4209509956709292141L;
    private int decodePos;
    private Integer hashCode;
    private final Map<String, JSONValue> fields;
    private String stringRepresentation;
    private final StringBuilder decodeBuffer;

    public JSONObject(JSONField ... fields) {
        if (fields == null || fields.length == 0) {
            this.fields = Collections.emptyMap();
        } else {
            LinkedHashMap<String, JSONValue> m = new LinkedHashMap<String, JSONValue>(fields.length);
            for (JSONField f : fields) {
                m.put(f.getName(), f.getValue());
            }
            this.fields = Collections.unmodifiableMap(m);
        }
        this.hashCode = null;
        this.stringRepresentation = null;
        this.decodePos = -1;
        this.decodeBuffer = null;
    }

    public JSONObject(Map<String, JSONValue> fields) {
        this.fields = fields == null ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, JSONValue>(fields));
        this.hashCode = null;
        this.stringRepresentation = null;
        this.decodePos = -1;
        this.decodeBuffer = null;
    }

    public JSONObject(String stringRepresentation) throws JSONException {
        this.stringRepresentation = stringRepresentation;
        char[] chars = stringRepresentation.toCharArray();
        this.decodePos = 0;
        this.decodeBuffer = new StringBuilder(chars.length);
        Object firstToken = this.readToken(chars);
        if (!firstToken.equals(Character.valueOf('{'))) {
            throw new JSONException(JSONMessages.ERR_OBJECT_DOESNT_START_WITH_BRACE.get(stringRepresentation));
        }
        LinkedHashMap<String, JSONValue> m = new LinkedHashMap<String, JSONValue>(10);
        this.readObject(chars, m);
        this.fields = Collections.unmodifiableMap(m);
        this.skipWhitespace(chars);
        if (this.decodePos < chars.length) {
            throw new JSONException(JSONMessages.ERR_OBJECT_DATA_BEYOND_END.get(stringRepresentation, this.decodePos));
        }
    }

    JSONObject(LinkedHashMap<String, JSONValue> fields, String stringRepresentation) {
        this.fields = Collections.unmodifiableMap(fields);
        this.stringRepresentation = stringRepresentation;
        this.hashCode = null;
        this.decodePos = -1;
        this.decodeBuffer = null;
    }

    private Object readToken(char[] chars) throws JSONException {
        this.skipWhitespace(chars);
        char c = this.readCharacter(chars, false);
        switch (c) {
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                ++this.decodePos;
                return Character.valueOf(c);
            }
            case '\"': {
                return this.readString(chars);
            }
            case 'f': 
            case 't': {
                return this.readBoolean(chars);
            }
            case 'n': {
                return this.readNull(chars);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.readNumber(chars);
            }
        }
        throw new JSONException(JSONMessages.ERR_OBJECT_INVALID_FIRST_TOKEN_CHAR.get(new String(chars), String.valueOf(c), this.decodePos));
    }

    private void skipWhitespace(char[] chars) throws JSONException {
        block5: while (this.decodePos < chars.length) {
            switch (chars[this.decodePos]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++this.decodePos;
                    continue block5;
                }
                case '/': {
                    int commentStartPos = this.decodePos;
                    if (this.decodePos + 1 >= chars.length) {
                        return;
                    }
                    if (chars[this.decodePos + 1] == '/') {
                        this.decodePos += 2;
                        while (this.decodePos < chars.length && chars[this.decodePos] != '\n' && chars[this.decodePos] != '\r') {
                            ++this.decodePos;
                        }
                        continue block5;
                    }
                    if (chars[this.decodePos + 1] == '*') {
                        this.decodePos += 2;
                        boolean closeFound = false;
                        while (this.decodePos < chars.length) {
                            if (chars[this.decodePos] == '*' && this.decodePos + 1 < chars.length && chars[this.decodePos + 1] == '/') {
                                closeFound = true;
                                this.decodePos += 2;
                                break;
                            }
                            ++this.decodePos;
                        }
                        if (closeFound) continue block5;
                        throw new JSONException(JSONMessages.ERR_OBJECT_UNCLOSED_COMMENT.get(new String(chars), commentStartPos));
                    }
                    return;
                }
                case '#': {
                    while (this.decodePos < chars.length && chars[this.decodePos] != '\n' && chars[this.decodePos] != '\r') {
                        ++this.decodePos;
                    }
                    continue block5;
                }
            }
            return;
        }
    }

    private char readCharacter(char[] chars, boolean advancePosition) throws JSONException {
        if (this.decodePos >= chars.length) {
            throw new JSONException(JSONMessages.ERR_OBJECT_UNEXPECTED_END_OF_STRING.get(new String(chars)));
        }
        char c = chars[this.decodePos];
        if (advancePosition) {
            ++this.decodePos;
        }
        return c;
    }

    private JSONString readString(char[] chars) throws JSONException {
        int startPos = this.decodePos++;
        this.decodeBuffer.setLength(0);
        while (true) {
            char c;
            if ((c = this.readCharacter(chars, true)) == '\\') {
                int escapedCharPos = this.decodePos;
                char escapedChar = this.readCharacter(chars, true);
                switch (escapedChar) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        this.decodeBuffer.append(escapedChar);
                        break;
                    }
                    case 'b': {
                        this.decodeBuffer.append('\b');
                        break;
                    }
                    case 'f': {
                        this.decodeBuffer.append('\f');
                        break;
                    }
                    case 'n': {
                        this.decodeBuffer.append('\n');
                        break;
                    }
                    case 'r': {
                        this.decodeBuffer.append('\r');
                        break;
                    }
                    case 't': {
                        this.decodeBuffer.append('\t');
                        break;
                    }
                    case 'u': {
                        char[] hexChars = new char[]{this.readCharacter(chars, true), this.readCharacter(chars, true), this.readCharacter(chars, true), this.readCharacter(chars, true)};
                        try {
                            this.decodeBuffer.append((char)Integer.parseInt(new String(hexChars), 16));
                            break;
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            throw new JSONException(JSONMessages.ERR_OBJECT_INVALID_UNICODE_ESCAPE.get(new String(chars), escapedCharPos), e);
                        }
                    }
                    default: {
                        throw new JSONException(JSONMessages.ERR_OBJECT_INVALID_ESCAPED_CHAR.get(new String(chars), Character.valueOf(escapedChar), escapedCharPos));
                    }
                }
                continue;
            }
            if (c == '\"') {
                return new JSONString(this.decodeBuffer.toString(), new String(chars, startPos, this.decodePos - startPos));
            }
            if (c <= '\u001f') {
                throw new JSONException(JSONMessages.ERR_OBJECT_UNESCAPED_CONTROL_CHAR.get(new String(chars), String.format("%04X", c), this.decodePos - 1));
            }
            this.decodeBuffer.append(c);
        }
    }

    private JSONBoolean readBoolean(char[] chars) throws JSONException {
        int startPos = this.decodePos;
        char firstCharacter = this.readCharacter(chars, true);
        if (firstCharacter == 't') {
            if (this.readCharacter(chars, true) == 'r' && this.readCharacter(chars, true) == 'u' && this.readCharacter(chars, true) == 'e') {
                return JSONBoolean.TRUE;
            }
        } else if (firstCharacter == 'f' && this.readCharacter(chars, true) == 'a' && this.readCharacter(chars, true) == 'l' && this.readCharacter(chars, true) == 's' && this.readCharacter(chars, true) == 'e') {
            return JSONBoolean.FALSE;
        }
        throw new JSONException(JSONMessages.ERR_OBJECT_UNABLE_TO_PARSE_BOOLEAN.get(new String(chars), startPos));
    }

    private JSONNull readNull(char[] chars) throws JSONException {
        int startPos = this.decodePos;
        if (this.readCharacter(chars, true) == 'n' && this.readCharacter(chars, true) == 'u' && this.readCharacter(chars, true) == 'l' && this.readCharacter(chars, true) == 'l') {
            return JSONNull.NULL;
        }
        throw new JSONException(JSONMessages.ERR_OBJECT_UNABLE_TO_PARSE_NULL.get(new String(chars), startPos));
    }

    private JSONNumber readNumber(char[] chars) throws JSONException {
        int startPos = this.decodePos;
        this.decodeBuffer.setLength(0);
        while (true) {
            char c = this.readCharacter(chars, true);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': 
                case ']': 
                case '}': {
                    --this.decodePos;
                    return new JSONNumber(this.decodeBuffer.toString());
                }
            }
            this.decodeBuffer.append(c);
        }
    }

    private JSONArray readArray(char[] chars) throws JSONException {
        int p;
        Object token;
        ArrayList<JSONValue> values = new ArrayList<JSONValue>(10);
        boolean firstToken = true;
        do {
            p = this.decodePos;
            token = this.readToken(chars);
            if (token instanceof JSONValue) {
                values.add((JSONValue)token);
            } else if (token.equals(Character.valueOf('['))) {
                values.add(this.readArray(chars));
            } else if (token.equals(Character.valueOf('{'))) {
                LinkedHashMap<String, JSONValue> fieldMap = new LinkedHashMap<String, JSONValue>(10);
                values.add(this.readObject(chars, fieldMap));
            } else {
                if (token.equals(Character.valueOf(']')) && firstToken) {
                    return JSONArray.EMPTY_ARRAY;
                }
                throw new JSONException(JSONMessages.ERR_OBJECT_INVALID_TOKEN_WHEN_ARRAY_VALUE_EXPECTED.get(new String(chars), String.valueOf(token), p));
            }
            firstToken = false;
            p = this.decodePos;
            token = this.readToken(chars);
            if (!token.equals(Character.valueOf(']'))) continue;
            return new JSONArray(values);
        } while (token.equals(Character.valueOf(',')));
        throw new JSONException(JSONMessages.ERR_OBJECT_INVALID_TOKEN_WHEN_ARRAY_COMMA_OR_BRACKET_EXPECTED.get(new String(chars), String.valueOf(token), p));
    }

    private JSONObject readObject(char[] chars, Map<String, JSONValue> fields) throws JSONException {
        int p;
        Object token;
        boolean firstField = true;
        do {
            String fieldName;
            p = this.decodePos;
            token = this.readToken(chars);
            if (token instanceof JSONString) {
                fieldName = ((JSONString)token).stringValue();
                if (fields.containsKey(fieldName)) {
                    throw new JSONException(JSONMessages.ERR_OBJECT_DUPLICATE_FIELD.get(new String(chars), fieldName));
                }
            } else {
                if (firstField && token.equals(Character.valueOf('}'))) {
                    return new JSONObject(fields);
                }
                throw new JSONException(JSONMessages.ERR_OBJECT_EXPECTED_STRING.get(new String(chars), String.valueOf(token), p));
            }
            firstField = false;
            p = this.decodePos;
            token = this.readToken(chars);
            if (!token.equals(Character.valueOf(':'))) {
                throw new JSONException(JSONMessages.ERR_OBJECT_EXPECTED_COLON.get(new String(chars), String.valueOf(token), p));
            }
            p = this.decodePos;
            token = this.readToken(chars);
            if (token instanceof JSONValue) {
                fields.put(fieldName, (JSONValue)token);
            } else if (token.equals(Character.valueOf('['))) {
                JSONArray a = this.readArray(chars);
                fields.put(fieldName, a);
            } else if (token.equals(Character.valueOf('{'))) {
                LinkedHashMap<String, JSONValue> m = new LinkedHashMap<String, JSONValue>(10);
                JSONObject o = this.readObject(chars, m);
                fields.put(fieldName, o);
            } else {
                throw new JSONException(JSONMessages.ERR_OBJECT_EXPECTED_VALUE.get(new String(chars), String.valueOf(token), p, fieldName));
            }
            p = this.decodePos;
            token = this.readToken(chars);
            if (!token.equals(Character.valueOf('}'))) continue;
            return new JSONObject(fields);
        } while (token.equals(Character.valueOf(',')));
        throw new JSONException(JSONMessages.ERR_OBJECT_EXPECTED_COMMA_OR_CLOSE_BRACE.get(new String(chars), String.valueOf(token), p));
    }

    public Map<String, JSONValue> getFields() {
        return this.fields;
    }

    public JSONValue getField(String name) {
        return this.fields.get(name);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            int hc = 0;
            for (Map.Entry<String, JSONValue> e : this.fields.entrySet()) {
                hc += e.getKey().hashCode() + e.getValue().hashCode();
            }
            this.hashCode = hc;
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JSONObject) {
            JSONObject obj = (JSONObject)o;
            return ((Object)this.fields).equals(obj.fields);
        }
        return false;
    }

    public boolean equals(JSONObject o, boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        if (!(ignoreFieldNameCase || ignoreValueCase || ignoreArrayOrder)) {
            return ((Object)this.fields).equals(o.fields);
        }
        if (this.fields.size() != o.fields.size()) {
            return false;
        }
        if (!ignoreFieldNameCase) {
            for (Map.Entry<String, JSONValue> e : this.fields.entrySet()) {
                JSONValue thisValue = e.getValue();
                JSONValue thatValue = o.fields.get(e.getKey());
                if (thatValue == null) {
                    return false;
                }
                if (thisValue.equals(thatValue, ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder)) continue;
                return false;
            }
            return true;
        }
        HashMap<String, JSONValue> thatMap = new HashMap<String, JSONValue>(o.fields);
        for (Map.Entry<String, JSONValue> thisEntry : this.fields.entrySet()) {
            String thisFieldName = thisEntry.getKey();
            JSONValue thisValue = thisEntry.getValue();
            Iterator<Map.Entry<String, JSONValue>> thatIterator = thatMap.entrySet().iterator();
            boolean found = false;
            while (thatIterator.hasNext()) {
                JSONValue thatValue;
                Map.Entry<String, JSONValue> thatEntry = thatIterator.next();
                String thatFieldName = thatEntry.getKey();
                if (!thisFieldName.equalsIgnoreCase(thatFieldName) || !thisValue.equals(thatValue = thatEntry.getValue(), ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder)) continue;
                found = true;
                thatIterator.remove();
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(JSONValue v, boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        return v instanceof JSONObject && this.equals((JSONObject)v, ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder);
    }

    @Override
    public String toString() {
        if (this.stringRepresentation == null) {
            StringBuilder buffer = new StringBuilder();
            this.toString(buffer);
            this.stringRepresentation = buffer.toString();
        }
        return this.stringRepresentation;
    }

    @Override
    public void toString(StringBuilder buffer) {
        if (this.stringRepresentation != null) {
            buffer.append(this.stringRepresentation);
            return;
        }
        buffer.append("{ ");
        Iterator<Map.Entry<String, JSONValue>> iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, JSONValue> e = iterator.next();
            JSONString.encodeString(e.getKey(), buffer);
            buffer.append(':');
            e.getValue().toString(buffer);
            if (iterator.hasNext()) {
                buffer.append(',');
            }
            buffer.append(' ');
        }
        buffer.append('}');
    }

    public String toMultiLineString() {
        JSONBuffer jsonBuffer = new JSONBuffer(null, 0, true);
        this.appendToJSONBuffer(jsonBuffer);
        return jsonBuffer.toString();
    }

    @Override
    public String toSingleLineString() {
        StringBuilder buffer = new StringBuilder();
        this.toSingleLineString(buffer);
        return buffer.toString();
    }

    @Override
    public void toSingleLineString(StringBuilder buffer) {
        buffer.append("{ ");
        Iterator<Map.Entry<String, JSONValue>> iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, JSONValue> e = iterator.next();
            JSONString.encodeString(e.getKey(), buffer);
            buffer.append(':');
            e.getValue().toSingleLineString(buffer);
            if (iterator.hasNext()) {
                buffer.append(',');
            }
            buffer.append(' ');
        }
        buffer.append('}');
    }

    @Override
    public String toNormalizedString() {
        StringBuilder buffer = new StringBuilder();
        this.toNormalizedString(buffer);
        return buffer.toString();
    }

    @Override
    public void toNormalizedString(StringBuilder buffer) {
        StringBuilder tempBuffer = this.decodeBuffer == null ? new StringBuilder(20) : this.decodeBuffer;
        TreeMap<String, String> m = new TreeMap<String, String>();
        for (Map.Entry<String, JSONValue> e : this.fields.entrySet()) {
            tempBuffer.setLength(0);
            tempBuffer.append('\"');
            for (char c : e.getKey().toCharArray()) {
                if (StaticUtils.isPrintable(c)) {
                    tempBuffer.append(c);
                    continue;
                }
                tempBuffer.append("\\u");
                tempBuffer.append(String.format("%04X", c));
            }
            tempBuffer.append('\"');
            String normalizedKey = tempBuffer.toString();
            tempBuffer.setLength(0);
            e.getValue().toNormalizedString(tempBuffer);
            m.put(normalizedKey, tempBuffer.toString());
        }
        buffer.append('{');
        Iterator iterator = m.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, JSONValue> e;
            e = iterator.next();
            buffer.append(e.getKey());
            buffer.append(':');
            buffer.append((String)((Object)e.getValue()));
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append('}');
    }

    @Override
    public void appendToJSONBuffer(JSONBuffer buffer) {
        buffer.beginObject();
        for (Map.Entry<String, JSONValue> field : this.fields.entrySet()) {
            String name = field.getKey();
            JSONValue value = field.getValue();
            value.appendToJSONBuffer(name, buffer);
        }
        buffer.endObject();
    }

    @Override
    public void appendToJSONBuffer(String fieldName, JSONBuffer buffer) {
        buffer.beginObject(fieldName);
        for (Map.Entry<String, JSONValue> field : this.fields.entrySet()) {
            String name = field.getKey();
            JSONValue value = field.getValue();
            value.appendToJSONBuffer(name, buffer);
        }
        buffer.endObject();
    }
}

