/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.core;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.appformer.maven.support.PomModel;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.guvnor.common.services.project.builder.events.InvalidateDMOModuleCacheEvent;
import org.guvnor.common.services.project.model.Module;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
@Named(value="LRUPomModelCache")
public class LRUPomModelCache
extends LRUCache<Module, PomModel> {
    private KieModuleService moduleService;

    public LRUPomModelCache() {
    }

    @Inject
    public LRUPomModelCache(KieModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public void invalidateProjectCache(@Observes InvalidateDMOModuleCacheEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        Path resourcePath = event.getResourcePath();
        KieModule module = (KieModule)this.moduleService.resolveModule(resourcePath);
        if (module != null) {
            this.invalidateCache(module);
        }
    }
}

