/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.project;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.builder.ObservablePOMFile;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.ModuleRepositories;
import org.guvnor.common.services.project.service.ModuleRepositoriesService;
import org.guvnor.common.services.project.service.ModuleRepositoryResolver;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.backend.project.KieModuleFactory;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceUpdated;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@ApplicationScoped
public class ModuleRepositoriesSynchronizer {
    private IOService ioService;
    private ModuleRepositoryResolver repositoryResolver;
    private ModuleRepositoriesService moduleRepositoriesService;
    private ObservablePOMFile observablePOMFile;
    private KieModuleFactory moduleFactory;

    public ModuleRepositoriesSynchronizer() {
    }

    @Inject
    public ModuleRepositoriesSynchronizer(@Named(value="ioStrategy") IOService ioService, ModuleRepositoryResolver repositoryResolver, ModuleRepositoriesService moduleRepositoriesService, ObservablePOMFile observablePOMFile, KieModuleFactory moduleFactory) {
        this.ioService = (IOService)PortablePreconditions.checkNotNull((String)"ioService", (Object)ioService);
        this.repositoryResolver = (ModuleRepositoryResolver)PortablePreconditions.checkNotNull((String)"repositoryResolver", (Object)repositoryResolver);
        this.moduleRepositoriesService = (ModuleRepositoriesService)PortablePreconditions.checkNotNull((String)"moduleRepositoriesService", (Object)moduleRepositoriesService);
        this.observablePOMFile = (ObservablePOMFile)PortablePreconditions.checkNotNull((String)"observablePOMFile", (Object)observablePOMFile);
        this.moduleFactory = (KieModuleFactory)PortablePreconditions.checkNotNull((String)"moduleFactory", (Object)moduleFactory);
    }

    public void onResourceUpdated(@Observes ResourceUpdatedEvent event) {
        if (this.observablePOMFile.accept(event.getPath())) {
            this.syncModuleRepositories(event.getPath());
        }
    }

    public void onBatchResourceChanges(@Observes ResourceBatchChangesEvent resourceBatchChangesEvent) {
        for (Map.Entry entry : resourceBatchChangesEvent.getBatch().entrySet()) {
            if (!this.observablePOMFile.accept((org.uberfire.backend.vfs.Path)entry.getKey()) || !this.isUpdate((Collection)entry.getValue())) continue;
            this.syncModuleRepositories((org.uberfire.backend.vfs.Path)entry.getKey());
            break;
        }
    }

    private boolean isUpdate(Collection<ResourceChange> value) {
        for (ResourceChange resourceChange : value) {
            if (!(resourceChange instanceof ResourceUpdated)) continue;
            return true;
        }
        return false;
    }

    private void syncModuleRepositories(org.uberfire.backend.vfs.Path _path) {
        Path path = this.ioService.get(URI.create(_path.toURI()));
        KieModule module = (KieModule)this.moduleFactory.simpleModuleInstance(path.getParent());
        ModuleRepositories moduleRepositories = (ModuleRepositories)this.moduleRepositoriesService.load(module.getRepositoriesPath());
        Set mavenRepositories = this.repositoryResolver.getRemoteRepositoriesMetaData((Module)module);
        HashSet<MavenRepositoryMetadata> existingMavenRepositories = new HashSet<MavenRepositoryMetadata>();
        HashSet<ModuleRepositories.ModuleRepository> repositoriesToRemove = new HashSet<ModuleRepositories.ModuleRepository>();
        for (ModuleRepositories.ModuleRepository moduleRepository : moduleRepositories.getRepositories()) {
            MavenRepositoryMetadata mavenRepositoryMetadata = moduleRepository.getMetadata();
            if (mavenRepositories.contains(mavenRepositoryMetadata)) {
                existingMavenRepositories.add(mavenRepositoryMetadata);
                continue;
            }
            repositoriesToRemove.add(moduleRepository);
        }
        HashSet<MavenRepositoryMetadata> repositoriesToAdd = new HashSet<MavenRepositoryMetadata>();
        for (MavenRepositoryMetadata mavenRepositoryMetadata : mavenRepositories) {
            if (existingMavenRepositories.contains(mavenRepositoryMetadata)) continue;
            repositoriesToAdd.add(mavenRepositoryMetadata);
        }
        for (ModuleRepositories.ModuleRepository moduleRepository : repositoriesToRemove) {
            moduleRepositories.getRepositories().remove(moduleRepository);
        }
        for (MavenRepositoryMetadata mavenRepositoryMetadata : repositoriesToAdd) {
            moduleRepositories.getRepositories().add(new ModuleRepositories.ModuleRepository(true, mavenRepositoryMetadata));
        }
        this.moduleRepositoriesService.save(module.getRepositoriesPath(), moduleRepositories, "Automatic synchronization");
    }
}

