/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.keycloak;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.resteasy.client.ClientResponse;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.ContextualManager;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.api.UserManagerSettings;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.api.exception.UserNotFoundException;
import org.uberfire.ext.security.management.impl.SearchResponseImpl;
import org.uberfire.ext.security.management.impl.UserManagerSettingsImpl;
import org.uberfire.ext.security.management.keycloak.BaseKeyCloakManager;
import org.uberfire.ext.security.management.keycloak.client.resource.RoleMappingResource;
import org.uberfire.ext.security.management.keycloak.client.resource.RoleResource;
import org.uberfire.ext.security.management.keycloak.client.resource.RolesResource;
import org.uberfire.ext.security.management.keycloak.client.resource.UserResource;
import org.uberfire.ext.security.management.keycloak.client.resource.UsersResource;
import org.uberfire.ext.security.management.util.SecurityManagementUtils;

public class KeyCloakUserManager
extends BaseKeyCloakManager
implements UserManager,
ContextualManager {
    private static final Logger LOG = LoggerFactory.getLogger(KeyCloakUserManager.class);
    private static final String CREDENTIAL_TYPE_PASSWORD = "password";
    UserSystemManager userSystemManager;

    public void initialize(UserSystemManager userSystemManager) throws Exception {
        this.userSystemManager = userSystemManager;
    }

    public AbstractEntityManager.SearchResponse<User> search(AbstractEntityManager.SearchRequest request) throws SecurityManagementException {
        AbstractEntityManager.SearchRequest req = this.getSearchRequest(request);
        if (req.getPage() <= 0) {
            throw new RuntimeException("First page must be 1.");
        }
        int page = req.getPage() - 1;
        int pageSize = req.getPageSize();
        ArrayList users = new ArrayList();
        int[] numberOfFoundUsers = new int[]{0};
        boolean[] hasNextPage = new boolean[]{false};
        this.consumeRealm(realmResource -> {
            UsersResource usersResource = realmResource.users();
            List<UserRepresentation> userRepresentations = usersResource.search(req.getSearchPattern(), page * pageSize, pageSize + 1);
            numberOfFoundUsers[0] = usersResource.search(req.getSearchPattern(), 1, Integer.MAX_VALUE).size();
            if (userRepresentations != null && !userRepresentations.isEmpty()) {
                int x = 0;
                for (UserRepresentation userRepresentation : userRepresentations) {
                    if (x == req.getPageSize()) {
                        hasNextPage[0] = true;
                        continue;
                    }
                    User user = this.createUser(userRepresentation);
                    users.add(user);
                    ++x;
                }
            }
        });
        return new SearchResponseImpl(users, page + 1, pageSize, numberOfFoundUsers[0], hasNextPage[0]);
    }

    public User get(String username) throws SecurityManagementException {
        PortablePreconditions.checkNotNull((String)"username", (Object)username);
        User[] user = new User[1];
        this.consumeRealm(realmResource -> {
            Set[] gr;
            UsersResource usersResource = realmResource.users();
            UserResource userResource = this.getUserResource(usersResource, username);
            RoleMappingResource roleMappingResource = userResource.roles();
            Set _groups = null;
            Set _roles = null;
            if (roleMappingResource != null && null != (gr = this.getUserGroupsAndRoles(roleMappingResource))) {
                _groups = gr[0];
                _roles = gr[1];
            }
            user[0] = this.createUser(userResource.toRepresentation(), _groups, _roles);
        });
        return user[0];
    }

    public List<User> getAll() throws SecurityManagementException {
        ArrayList<User> users = new ArrayList<User>();
        this.consumeRealm(realmResource -> {
            UsersResource usersResource = realmResource.users();
            List<UserRepresentation> userRepresentations = usersResource.list();
            if (userRepresentations != null && !userRepresentations.isEmpty()) {
                for (UserRepresentation userRepresentation : userRepresentations) {
                    User user = this.createUser(userRepresentation);
                    users.add(user);
                }
            }
        });
        return users;
    }

    public User create(User entity) throws SecurityManagementException {
        PortablePreconditions.checkNotNull((String)"entity", (Object)entity);
        this.consumeRealm(realmResource -> {
            UsersResource usersResource = realmResource.users();
            UserRepresentation userRepresentation = new UserRepresentation();
            this.fillUserRepresentationAttributes(entity, userRepresentation);
            ClientResponse response = (ClientResponse)usersResource.create(userRepresentation);
            this.handleResponse(response);
        });
        return entity;
    }

    public User update(User entity) throws SecurityManagementException {
        PortablePreconditions.checkNotNull((String)"entity", (Object)entity);
        this.consumeRealm(realmResource -> {
            UsersResource usersResource = realmResource.users();
            UserResource userResource = this.getUserResource(usersResource, entity.getIdentifier());
            if (userResource == null) {
                throw new UserNotFoundException(entity.getIdentifier());
            }
            UserRepresentation userRepresentation = new UserRepresentation();
            this.fillUserRepresentationAttributes(entity, userRepresentation);
            ClientResponse response = (ClientResponse)userResource.update(userRepresentation);
            this.handleResponse(response);
        });
        return entity;
    }

    public void delete(String ... identifiers) throws SecurityManagementException {
        PortablePreconditions.checkNotNull((String)"identifiers", (Object)identifiers);
        this.consumeRealm(realmResource -> {
            UsersResource usersResource = realmResource.users();
            for (String identifier : identifiers) {
                UserResource userResource = this.getUserResource(usersResource, identifier);
                if (userResource == null) {
                    throw new UserNotFoundException(identifier);
                }
                ClientResponse response = (ClientResponse)userResource.remove();
                this.handleResponse(response);
            }
        });
    }

    public UserManagerSettings getSettings() {
        HashMap<Capability, CapabilityStatus> capabilityStatusMap = new HashMap<Capability, CapabilityStatus>(8);
        for (Capability capability : SecurityManagementUtils.USERS_CAPABILITIES) {
            capabilityStatusMap.put(capability, this.getCapabilityStatus(capability));
        }
        return new UserManagerSettingsImpl(capabilityStatusMap, USER_ATTRIBUTES);
    }

    public void assignGroups(String username, Collection<String> groups) throws SecurityManagementException {
        PortablePreconditions.checkNotNull((String)"username", (Object)username);
        Set userRoles = SecurityManagementUtils.rolesToString((Set)SecurityManagementUtils.getRoles((UserSystemManager)this.userSystemManager, (String)username));
        userRoles.addAll(groups);
        this.assignGroupsOrRoles(username, userRoles);
    }

    public void assignRoles(String username, Collection<String> roles) throws SecurityManagementException {
        PortablePreconditions.checkNotNull((String)"username", (Object)username);
        Set userGroups = SecurityManagementUtils.groupsToString((Set)SecurityManagementUtils.getGroups((UserSystemManager)this.userSystemManager, (String)username));
        userGroups.addAll(roles);
        this.assignGroupsOrRoles(username, userGroups);
    }

    private void assignGroupsOrRoles(String username, Collection<String> idsToAssign) throws SecurityManagementException {
        PortablePreconditions.checkNotNull((String)"username", (Object)username);
        this.consumeRealm(realmResource -> {
            UsersResource usersResource = realmResource.users();
            UserResource userResource = this.getUserResource(usersResource, username);
            if (userResource == null) {
                throw new UserNotFoundException(username);
            }
            RolesResource rolesResource = realmResource.roles();
            List<RoleRepresentation> roleRepresentations = userResource.roles().realmLevel().listEffective();
            userResource.roles().realmLevel().remove(roleRepresentations);
            if (idsToAssign != null && !idsToAssign.isEmpty()) {
                ArrayList<RoleRepresentation> rolesToAdd = new ArrayList<RoleRepresentation>();
                for (String name : idsToAssign) {
                    RoleResource roleResource = rolesResource.get(name);
                    if (roleResource == null) continue;
                    rolesToAdd.add(this.getRoleRepresentation(name, roleResource));
                }
                userResource.roles().realmLevel().add(rolesToAdd);
            }
        });
    }

    public void changePassword(String username, String newPassword) throws SecurityManagementException {
        PortablePreconditions.checkNotNull((String)"username", (Object)username);
        this.consumeRealm(realmResource -> {
            UsersResource usersResource = realmResource.users();
            UserResource userResource = this.getUserResource(usersResource, username);
            if (userResource == null) {
                throw new UserNotFoundException(username);
            }
            CredentialRepresentation credentialRepresentation = new CredentialRepresentation();
            credentialRepresentation.setType(CREDENTIAL_TYPE_PASSWORD);
            credentialRepresentation.setValue(newPassword);
            userResource.resetPassword(credentialRepresentation);
        });
    }

    protected CapabilityStatus getCapabilityStatus(Capability capability) {
        if (capability != null) {
            switch (capability) {
                case CAN_SEARCH_USERS: 
                case CAN_ADD_USER: 
                case CAN_UPDATE_USER: 
                case CAN_DELETE_USER: 
                case CAN_READ_USER: 
                case CAN_MANAGE_ATTRIBUTES: 
                case CAN_ASSIGN_GROUPS: 
                case CAN_ASSIGN_ROLES: 
                case CAN_CHANGE_PASSWORD: {
                    return CapabilityStatus.ENABLED;
                }
            }
        }
        return CapabilityStatus.UNSUPPORTED;
    }

    public void destroy() throws Exception {
        this.getKeyCloakInstance().close();
    }
}

