/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.failover.impl.AuroraListener;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.protocol.MastersSlavesProtocol;
import org.mariadb.jdbc.internal.query.MariaDbQuery;
import org.mariadb.jdbc.internal.queryresults.SelectQueryResult;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class AuroraProtocol
extends MastersSlavesProtocol {
    public AuroraProtocol(UrlParser url, ReentrantLock lock) {
        super(url, lock);
    }

    public static void searchProbableMaster(AuroraListener listener, HostAddress probableMaster, SearchFilter searchFilter) throws QueryException {
        AuroraProtocol protocol = AuroraProtocol.getNewProtocol(listener.getProxy(), listener.getUrlParser());
        try {
            protocol.setHostAddress(probableMaster);
            protocol.connect();
            listener.removeFromBlacklist(protocol.getHostAddress());
            if (listener.isMasterHostFailReconnect() && protocol.isMasterConnection()) {
                protocol.setMustBeMasterConnection(true);
                listener.foundActiveMaster(protocol);
            } else if (listener.isSecondaryHostFailReconnect() && !protocol.isMasterConnection()) {
                protocol.setMustBeMasterConnection(false);
                listener.foundActiveSecondary(protocol);
            } else {
                protocol.close();
                protocol = AuroraProtocol.getNewProtocol(listener.getProxy(), listener.getUrlParser());
            }
        }
        catch (QueryException e) {
            listener.addToBlacklist(protocol.getHostAddress());
        }
    }

    public static void loop(AuroraListener listener, List<HostAddress> addresses, SearchFilter searchFilter) throws QueryException {
        ArrayDeque<HostAddress> loopAddresses = new ArrayDeque<HostAddress>(!addresses.isEmpty() ? addresses : listener.getBlacklistKeys());
        if (loopAddresses.isEmpty()) {
            loopAddresses.addAll(listener.getUrlParser().getHostAddresses());
        }
        int maxConnectionTry = listener.getRetriesAllDown();
        QueryException lastQueryException = null;
        while (!loopAddresses.isEmpty() || !searchFilter.isFailoverLoop() && maxConnectionTry > 0) {
            AuroraProtocol protocol = AuroraProtocol.getNewProtocol(listener.getProxy(), listener.getUrlParser());
            if (listener.isExplicitClosed() || !listener.isSecondaryHostFailReconnect() && !listener.isMasterHostFailReconnect()) {
                return;
            }
            --maxConnectionTry;
            try {
                HostAddress host = loopAddresses.pollFirst();
                if (host == null) {
                    loopAddresses.addAll(listener.getUrlParser().getHostAddresses());
                    host = loopAddresses.pollFirst();
                }
                protocol.setHostAddress(host);
                protocol.connect();
                if (listener.isExplicitClosed()) {
                    protocol.close();
                    return;
                }
                listener.removeFromBlacklist(protocol.getHostAddress());
                if (listener.isMasterHostFailReconnect() && protocol.isMasterConnection()) {
                    if (AuroraProtocol.foundMaster(listener, protocol, searchFilter)) {
                        return;
                    }
                } else if (listener.isSecondaryHostFailReconnect() && !protocol.isMasterConnection()) {
                    if (AuroraProtocol.foundSecondary(listener, protocol, searchFilter)) {
                        return;
                    }
                    HostAddress probableMasterHost = listener.searchByStartName(protocol, listener.getUrlParser().getHostAddresses());
                    if (probableMasterHost != null) {
                        loopAddresses.remove(probableMasterHost);
                        AuroraProtocol.searchProbableMaster(listener, probableMasterHost, searchFilter);
                        if (listener.isMasterHostFailReconnect() && searchFilter.isFineIfFoundOnlySlave()) {
                            return;
                        }
                    }
                } else {
                    protocol.close();
                }
            }
            catch (QueryException e) {
                lastQueryException = e;
                listener.addToBlacklist(protocol.getHostAddress());
            }
            if (!listener.isMasterHostFailReconnect() && !listener.isSecondaryHostFailReconnect()) {
                return;
            }
            if (!loopAddresses.isEmpty() || searchFilter.isFailoverLoop() || maxConnectionTry <= 0) continue;
            loopAddresses = new ArrayDeque<HostAddress>(listener.getBlacklistKeys());
        }
        if (listener.isMasterHostFailReconnect() || listener.isMasterHostFailReconnect()) {
            String error = "No active connection found for replica";
            if (listener.isMasterHostFailReconnect()) {
                error = "No active connection found for master";
            }
            if (lastQueryException != null) {
                throw new QueryException(error, lastQueryException.getErrorCode(), lastQueryException.getSqlState(), lastQueryException);
            }
            throw new QueryException(error);
        }
    }

    public static AuroraProtocol getNewProtocol(FailoverProxy proxy, UrlParser urlParser) {
        AuroraProtocol newProtocol = new AuroraProtocol(urlParser, proxy.lock);
        newProtocol.setProxy(proxy);
        return newProtocol;
    }

    @Override
    public boolean isMasterConnection() {
        return this.masterConnection;
    }

    @Override
    public boolean checkIfMaster() throws QueryException {
        this.proxy.lock.lock();
        try {
            SelectQueryResult queryResult = (SelectQueryResult)this.executeQuery(new MariaDbQuery("show global variables like 'innodb_read_only'"));
            if (queryResult != null) {
                queryResult.next();
                this.masterConnection = "OFF".equals(queryResult.getValueObject(1).getString());
            } else {
                this.masterConnection = false;
            }
            this.readOnly = !this.masterConnection;
            boolean bl = this.masterConnection;
            return bl;
        }
        catch (SQLException sqle) {
            throw new QueryException("could not check the 'innodb_read_only' variable status on " + this.getHostAddress() + " : " + sqle.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), sqle);
        }
        catch (IOException ioe) {
            throw new QueryException("could not check the 'innodb_read_only' variable status on " + this.getHostAddress() + " : " + ioe.getMessage(), -1, ExceptionMapper.SqlStates.CONNECTION_EXCEPTION.getSqlState(), ioe);
        }
        finally {
            this.proxy.lock.unlock();
        }
    }
}

