/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.factory.impl;

import java.util.HashSet;
import java.util.Set;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionId;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

public abstract class AbstractElementFactory<C, D extends Definition<C>, T extends Element<D>>
implements ElementFactory<C, D, T> {
    protected AbstractElementFactory() {
    }

    protected abstract DefinitionManager getDefinitionManager();

    protected void appendLabels(Set<String> target, Object definition) {
        String[] labels;
        for (String label : labels = AbstractElementFactory.computeLabels(this.getDefinitionManager().adapters().registry().getDefinitionAdapter(definition.getClass()), definition)) {
            target.add(label);
        }
    }

    public static <T> String[] computeLabels(DefinitionAdapter<T> adapter, T definition) {
        String[] labels;
        HashSet<String> target = new HashSet<String>();
        DefinitionId id = adapter.getId(definition);
        target.add(id.value());
        if (id.isDynamic()) {
            target.add(id.type());
        }
        if (null != (labels = adapter.getLabels(definition))) {
            for (String label : labels) {
                target.add(label);
            }
        }
        return target.toArray(new String[target.size()]);
    }
}

