/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.Collection;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.RemoveParentCommand;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Parent;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.util.UUID;

@Portable
public final class SetParentNodeCommand
extends AbstractGraphCommand {
    private final String parentUUID;
    private final String candidateUUID;
    private transient Node<?, Edge> parent;
    private transient Node<?, Edge> candidate;

    public SetParentNodeCommand(@MapsTo(value="parentUUID") String parentUUID, @MapsTo(value="candidateUUID") String candidateUUID) {
        this.parentUUID = (String)PortablePreconditions.checkNotNull((String)"parentUUID", (Object)parentUUID);
        this.candidateUUID = (String)PortablePreconditions.checkNotNull((String)"candidateUUID", (Object)candidateUUID);
    }

    public SetParentNodeCommand(Node<?, Edge> parent, Node<?, Edge> candidate) {
        this(parent.getUUID(), candidate.getUUID());
        this.parent = parent;
        this.candidate = candidate;
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        CommandResult<RuleViolation> results = this.allow(context);
        if (!results.getType().equals((Object)CommandResult.Type.ERROR)) {
            Node<?, Edge> parent = this.getParent(context);
            Node<?, Edge> candidate = this.getCandidate(context);
            String uuid = UUID.uuid();
            EdgeImpl edge = new EdgeImpl(uuid);
            edge.setContent(new Parent());
            edge.setSourceNode(parent);
            edge.setTargetNode(candidate);
            parent.getOutEdges().add(edge);
            candidate.getInEdges().add(edge);
            this.getMutableIndex(context).addEdge(edge);
        }
        return results;
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        Node<?, Edge> parent = this.getParent(context);
        Node<?, Edge> candidate = this.getCandidate(context);
        Collection<RuleViolation> containmentRuleViolations = this.evaluate(context, contextBuilder -> contextBuilder.containment((Element<? extends Definition<?>>)parent, (Node<? extends Definition<?>, ? extends Edge>)candidate));
        return new GraphCommandResultBuilder(containmentRuleViolations).build();
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        Node<?, Edge> parent = this.getParent(context);
        Node<?, Edge> candidate = this.getCandidate(context);
        RemoveParentCommand undoCommand = new RemoveParentCommand(parent, candidate);
        return undoCommand.execute(context);
    }

    private Node<?, Edge> getParent(GraphCommandExecutionContext context) {
        if (null == this.parent) {
            this.parent = this.getNodeNotNull(context, this.parentUUID);
        }
        return this.parent;
    }

    private Node<?, Edge> getCandidate(GraphCommandExecutionContext context) {
        if (null == this.candidate) {
            this.candidate = this.getNodeNotNull(context, this.candidateUUID);
        }
        return this.candidate;
    }

    public String toString() {
        return "AddParentEdgeCommand [parent=" + this.parentUUID + ", candidate=" + this.candidateUUID + "]";
    }
}

