/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.index.map;

import java.util.Map;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.processing.index.MutableIndex;

public class MapIndex
implements MutableIndex<Node, Edge> {
    final Graph<?, Node> graph;
    final Map<String, Node> nodes;
    final Map<String, Edge> edges;

    public MapIndex(Graph<?, Node> graph, Map<String, Node> nodes, Map<String, Edge> edges) {
        this.graph = graph;
        this.nodes = nodes;
        this.edges = edges;
    }

    public Graph<?, Node> getGraph() {
        return this.graph;
    }

    public Element get(String uuid) {
        Element node = (Element)this.nodes.get(uuid);
        if (null == node) {
            return (Element)this.edges.get(uuid);
        }
        return node;
    }

    public Node getNode(String uuid) {
        return this.nodes.get(uuid);
    }

    public Edge getEdge(String uuid) {
        return this.edges.get(uuid);
    }

    public MutableIndex<Node, Edge> addNode(Node node) {
        this.nodes.put(node.getUUID(), node);
        return this;
    }

    public MutableIndex<Node, Edge> removeNode(Node node) {
        this.nodes.remove(node.getUUID());
        return this;
    }

    public MutableIndex<Node, Edge> addEdge(Edge edge) {
        this.edges.put(edge.getUUID(), edge);
        return this;
    }

    public MutableIndex<Node, Edge> removeEdge(Edge edge) {
        this.edges.remove(edge.getUUID());
        return this;
    }

    public void clear() {
        this.nodes.clear();
        this.edges.clear();
    }
}

