/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule.handler.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationHandler;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.NodeContainmentContext;
import org.kie.workbench.common.stunner.core.rule.context.impl.RuleEvaluationContextBuilder;
import org.kie.workbench.common.stunner.core.rule.handler.impl.ContainmentEvaluationHandler;
import org.kie.workbench.common.stunner.core.rule.handler.impl.GraphEvaluationHandlerUtils;
import org.kie.workbench.common.stunner.core.rule.impl.CanContain;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;

@ApplicationScoped
public class NodeContainmentEvaluationHandler
implements RuleEvaluationHandler<CanContain, NodeContainmentContext> {
    private final ContainmentEvaluationHandler containmentHandler;
    private final GraphEvaluationHandlerUtils evalUtils;

    protected NodeContainmentEvaluationHandler() {
        this(null, null);
    }

    @Inject
    public NodeContainmentEvaluationHandler(DefinitionManager definitionManager, ContainmentEvaluationHandler containmentHandler) {
        this.containmentHandler = containmentHandler;
        this.evalUtils = new GraphEvaluationHandlerUtils(definitionManager);
    }

    public Class<CanContain> getRuleType() {
        return CanContain.class;
    }

    public Class<NodeContainmentContext> getContextType() {
        return NodeContainmentContext.class;
    }

    public boolean accepts(CanContain rule, NodeContainmentContext context) {
        Set<String> parenteLabels = this.evalUtils.getLabels(context.getParent());
        return this.containmentHandler.accepts(rule, RuleEvaluationContextBuilder.DomainContexts.containment(parenteLabels, Collections.emptySet()));
    }

    public RuleViolations evaluate(CanContain rule, NodeContainmentContext context) {
        Element parent = context.getParent();
        Set<String> parentLabels = this.evalUtils.getLabels(parent);
        DefaultRuleViolations result = new DefaultRuleViolations();
        Collection candidates = context.getCandidates();
        candidates.forEach(candidate -> result.addViolations(this.evaluate(rule, candidate.getUUID(), this.evalUtils.getLabels((Element<? extends Definition<?>>)candidate), parentLabels)));
        return result;
    }

    private RuleViolations evaluate(CanContain rule, String candidateUUID, Set<String> candidateLabels, Set<String> parentLabels) {
        RuleViolations result = this.containmentHandler.evaluate(rule, RuleEvaluationContextBuilder.DomainContexts.containment(parentLabels, candidateLabels));
        return GraphEvaluationHandlerUtils.addViolationsSourceUUID(candidateUUID, result);
    }
}

