/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.Authorizer;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.access.rbac.RunAsRoleMapper;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.access.RoleMappingResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class IsCallerInRoleOperation
implements OperationStepHandler {
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("is-caller-in-role", DomainManagementResolver.getResolver("core", "management", "access-control")).setReplyType(ModelType.BOOLEAN).setReadOnly().build();
    private final Authorizer authorizer;

    private IsCallerInRoleOperation(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String roleName = RoleMappingResourceDefinition.getRoleName(operation);
        if (context.getCurrentStage() == OperationContext.Stage.MODEL) {
            context.addStep((OperationStepHandler)this, OperationContext.Stage.RUNTIME);
        } else {
            ModelNode result = context.getResult();
            Set operationHeaderRoles = RunAsRoleMapper.getOperationHeaderRoles((ModelNode)operation);
            result.set(this.isCallerInRole(roleName, context.getCaller(), context.getCallEnvironment(), operationHeaderRoles));
        }
    }

    private boolean isCallerInRole(String roleName, Caller caller, Environment callEnvironment, Set<String> operationHeaderRoles) {
        Set mappedRoles = this.authorizer.getCallerRoles(caller, callEnvironment, operationHeaderRoles);
        if (mappedRoles == null) {
            return false;
        }
        if (mappedRoles.contains(roleName)) {
            return true;
        }
        for (String role : mappedRoles) {
            if (!role.equalsIgnoreCase(roleName)) continue;
            return true;
        }
        return false;
    }

    public static OperationStepHandler create(Authorizer authorizer) {
        return new IsCallerInRoleOperation(authorizer);
    }
}

