/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.ssh;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.daemon.ssh.BaseGitCommand;

public class GitReceiveCommand
extends BaseGitCommand {
    private final ReceivePackFactory<BaseGitCommand> receivePackFactory;

    public GitReceiveCommand(String command, JGitFileSystemProvider.RepositoryResolverImpl<BaseGitCommand> repositoryResolver, ReceivePackFactory<BaseGitCommand> receivePackFactory, ExecutorService executorService) {
        super(command, repositoryResolver, executorService);
        this.receivePackFactory = receivePackFactory;
    }

    @Override
    protected String getCommandName() {
        return "git-receive-pack";
    }

    @Override
    protected void execute(Repository repository, InputStream in, OutputStream out, OutputStream err) {
        try {
            ReceivePack rp = this.receivePackFactory.create((Object)this, repository);
            rp.receive(in, out, err);
            rp.setPostReceiveHook((rp1, commands) -> new Git(repository).gc());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

