/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class GetCommit {
    private final Git git;
    private final String commitId;

    public GetCommit(Git git, String commitId) {
        this.git = (Git)PortablePreconditions.checkNotNull((String)"git", (Object)git);
        this.commitId = PortablePreconditions.checkNotEmpty((String)"commitId", (String)commitId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RevCommit execute() {
        Repository repository = this.git.getRepository();
        try (RevWalk revWalk = new RevWalk(repository);){
            ObjectId id = repository.resolve(this.commitId);
            RevCommit revCommit = id != null ? revWalk.parseCommit((AnyObjectId)id) : null;
            return revCommit;
        }
        catch (Exception e) {
            throw new GitException("Error when trying to get commit", e);
        }
    }
}

