/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.jgit.util.FileUtils;
import org.guvnor.structure.backend.organizationalunit.config.SpaceConfigStorageImpl;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.RemoveOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.api.FileSystemUtils;
import org.uberfire.java.nio.fs.jgit.FileSystemLock;
import org.uberfire.java.nio.fs.jgit.FileSystemLockManager;
import org.uberfire.spaces.Space;

@Singleton
@Startup
public class FileSystemDeleteWorker {
    private static final int LAST_ACCESS_THRESHOLD = 10;
    private static final TimeUnit LAST_ACCESS_TIME_UNIT = TimeUnit.SECONDS;
    private static final String LOCK_NAME = "delete.lock";
    public static final String CRON_MINUTES = "*/1";
    private Logger logger = LoggerFactory.getLogger(FileSystemDeleteWorker.class);
    private IOService ioService;
    private OrganizationalUnitService organizationalUnitService;
    private RepositoryService repositoryService;
    private FileSystem systemFS;
    private SpaceConfigStorageRegistry registry;
    private Event<RemoveOrganizationalUnitEvent> removeOrganizationalUnitEvent;
    private ConfigurationService configurationService;
    private boolean busy = false;

    public FileSystemDeleteWorker() {
    }

    @Inject
    public FileSystemDeleteWorker(@Named(value="ioStrategy") IOService ioService, OrganizationalUnitService organizationalUnitService, RepositoryService repositoryService, @Named(value="systemFS") FileSystem systemFS, SpaceConfigStorageRegistry registry, Event<RemoveOrganizationalUnitEvent> removeOrganizationalUnitEvent, ConfigurationService configurationService) {
        this.ioService = ioService;
        this.organizationalUnitService = organizationalUnitService;
        this.repositoryService = repositoryService;
        this.systemFS = systemFS;
        this.registry = registry;
        this.removeOrganizationalUnitEvent = removeOrganizationalUnitEvent;
        this.configurationService = configurationService;
    }

    @Schedule(hour="*", minute="*/1", persistent=false)
    public void doRemove() {
        if (this.busy || !this.isDeleteWorkerEnabled()) {
            return;
        }
        this.busy = true;
        this.ifDebugEnabled(this.logger, () -> this.logger.debug("Trying to acquire lock"));
        this.lockedOperation(() -> {
            this.ifDebugEnabled(this.logger, () -> this.logger.debug("Lock acquired, executing Delete Operation"));
            this.removeAllDeletedSpaces();
            this.removeAllDeletedRepositories();
        });
        this.ifDebugEnabled(this.logger, () -> this.logger.debug("Delete Operation finished."));
        this.busy = false;
    }

    protected boolean isDeleteWorkerEnabled() {
        return FileSystemUtils.isGitDefaultFileSystem();
    }

    protected void removeAllDeletedRepositories() {
        try {
            this.ifDebugEnabled(this.logger, () -> this.logger.debug("Removing all deleted repositories"));
            Collection spaces = this.organizationalUnitService.getAllOrganizationalUnits(false, X -> true);
            List<Repository> deletedRepositories = spaces.stream().filter(organizationalUnit -> organizationalUnit != null).map(organizationalUnit -> this.repositoryService.getAllDeletedRepositories(organizationalUnit.getSpace())).flatMap(x -> x.stream()).collect(Collectors.toList());
            this.ifDebugEnabled(this.logger, () -> this.logger.debug("Found {} spaces with deleted repositories", (Object)deletedRepositories.size()));
            deletedRepositories.forEach(organizationalUnit -> this.removeRepository((Repository)organizationalUnit));
            this.ifDebugEnabled(this.logger, () -> this.logger.debug("Deleted repositories had been removed"));
        }
        catch (Exception e) {
            this.ifDebugEnabled(this.logger, () -> this.logger.error("Error when trying to remove all deleted repositories", (Throwable)e));
        }
    }

    protected void removeAllDeletedSpaces() {
        try {
            this.ifDebugEnabled(this.logger, () -> this.logger.debug("Removing all deleted spaces"));
            Collection deletedSpaces = this.organizationalUnitService.getAllDeletedOrganizationalUnit();
            this.ifDebugEnabled(this.logger, () -> this.logger.debug("Found {} spaces to be deleted", (Object)deletedSpaces.size()));
            deletedSpaces.forEach(ou -> this.removeSpaceDirectory(ou.getSpace()));
            if (deletedSpaces.size() > 0) {
                this.removeOrganizationalUnitEvent.fire((Object)new RemoveOrganizationalUnitEvent());
            }
            this.ifDebugEnabled(this.logger, () -> this.logger.debug("Deleted spaces had been removed"));
        }
        catch (Exception e) {
            this.ifDebugEnabled(this.logger, () -> this.logger.error("Error when trying to remove all deleted Spaces", (Throwable)e));
        }
    }

    protected void removeSpaceDirectory(Space space) {
        try {
            Collection repositories = this.repositoryService.getAllRepositories(space, true);
            repositories.forEach(repository -> this.removeRepository((Repository)repository));
            SpaceConfigStorageImpl configStorage = (SpaceConfigStorageImpl)this.registry.get(space.getName());
            Path configPath = configStorage.getPath();
            File spacePath = this.getSpacePath(configPath.getFileSystem().getPath("/", new String[0]));
            Path configFSPath = configPath.getFileSystem().getPath("/", new String[0]);
            this.ioService.deleteIfExists(configFSPath, new DeleteOption[0]);
            this.registry.remove(space.getName());
            this.delete(spacePath);
            this.removeSpaceFromConfigurationService(space);
        }
        catch (Exception e) {
            this.ifDebugEnabled(this.logger, () -> this.logger.error("A problem occurred when trying to delete " + space.getName() + " space", (Throwable)e));
        }
    }

    private void removeSpaceFromConfigurationService(Space space) {
        String spaceName = space.getName();
        this.configurationService.startBatch();
        Optional<ConfigGroup> configGroup = this.findConfigGroupBySpaceName(spaceName);
        configGroup.ifPresent(cg -> this.configurationService.removeConfiguration(cg));
        this.configurationService.endBatch();
    }

    private Optional<ConfigGroup> findConfigGroupBySpaceName(String spaceName) {
        List configurations = this.configurationService.getConfiguration(ConfigType.SPACE);
        return configurations.stream().filter(cg -> cg.getName().equalsIgnoreCase(spaceName)).findFirst();
    }

    protected void delete(File path) throws IOException {
        FileUtils.delete((File)path, (int)7);
    }

    protected File getSpacePath(Path configPath) {
        return configPath.toFile().getParentFile().getParentFile();
    }

    protected void removeRepository(Repository repo) {
        try {
            Path path = this.getPath(repo);
            this.ioService.deleteIfExists(path, new DeleteOption[0]);
            SpaceConfigStorageImpl configStorage = (SpaceConfigStorageImpl)this.registry.get(repo.getSpace().getName());
            configStorage.deleteRepository(repo.getAlias());
            if (!this.ioService.exists(path)) {
                this.removeRepositoryFromSpaceInfo(repo);
            }
        }
        catch (Exception e) {
            this.ifDebugEnabled(this.logger, () -> this.logger.error("A problem occurred when trying to delete " + repo.getAlias() + " repository", (Throwable)e));
        }
    }

    private Path getPath(Repository repo) {
        return this.getFS(repo).getPath("", new String[0]);
    }

    private FileSystem getFS(Repository repo) {
        Branch defaultBranch = (Branch)repo.getDefaultBranch().orElseThrow(() -> new IllegalStateException("Repository should have at least one branch."));
        return Paths.convert((org.uberfire.backend.vfs.Path)defaultBranch.getPath()).getFileSystem();
    }

    private void removeRepositoryFromSpaceInfo(Repository repo) {
        this.registry.getBatch(repo.getSpace().getName()).run(context -> {
            context.getSpaceInfo().removeRepository(repo.getAlias());
            context.saveSpaceInfo();
            return null;
        });
    }

    private File getSystemRepository() {
        return this.systemFS.getPath("/", new String[0]).toFile();
    }

    private void lockedOperation(Runnable runnable) {
        FileSystemLock physicalLock = this.createLock(this.getSystemRepository().getParentFile().getParentFile());
        try {
            physicalLock.lock();
            runnable.run();
        }
        finally {
            physicalLock.unlock();
        }
    }

    protected FileSystemLock createLock(File file) {
        this.ifDebugEnabled(this.logger, () -> this.logger.debug("Acquiring lock: " + file.getAbsolutePath() + " - " + LOCK_NAME));
        return FileSystemLockManager.getInstance().getFileSystemLock(file, LOCK_NAME, LAST_ACCESS_TIME_UNIT, 10L);
    }

    private void ifDebugEnabled(Logger logger, Runnable message) {
        if (logger.isDebugEnabled()) {
            message.run();
        }
    }
}

