/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.core;

import java.io.InputStream;
import java.util.Properties;
import org.kie.workbench.common.screens.datasource.management.backend.core.impl.DataSourceProviderFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceSettings {
    public static final String DATASOURCE_MANAGEMENT_PREFIX = "datasource.management";
    private static final Logger logger = LoggerFactory.getLogger(DataSourceSettings.class);
    private static final String DATASOURCE_MANAGEMENT_PROPERTIES = "datasource-management.properties";
    private static DataSourceSettings instance;
    private Properties properties;

    private DataSourceSettings(Properties properties) {
        this.properties = properties;
    }

    public static DataSourceSettings getInstance() {
        if (instance == null) {
            instance = new DataSourceSettings(DataSourceSettings.loadSettings());
        }
        return instance;
    }

    public String getProperty(String value) {
        return this.properties.getProperty(value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    private static Properties loadSettings() {
        InputStream inputStream = DataSourceProviderFactoryImpl.class.getResourceAsStream("/datasource-management.properties");
        Properties properties = new Properties();
        if (inputStream == null) {
            logger.warn("Data source management configuration file: datasource-management.properties was not found. Some features may be disabled in current installation.");
            return properties;
        }
        try {
            properties.load(inputStream);
        }
        catch (Exception e) {
            logger.error("An error was produced during data source configuration file reading: datasource-management.properties", (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                logger.warn("An error was produced during data source configuration file closing: datasource-management.properties", (Throwable)e);
            }
        }
        return properties;
    }
}

