/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.slack;

import com.github.seratch.jslack.api.methods.response.channels.ChannelsListResponse;
import com.github.seratch.jslack.api.model.Channel;
import java.util.List;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.slack.SlackAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="SlackPostMessageToChannelDefinitions.wid", name="SlackPostMessageToChannel", displayName="SlackPostMessageToChannel", defaultHandler="mvel: new org.jbpm.process.workitem.slack.PostMessageToChannelWorkitemHandler(\"accessToken\")", documentation="slack-workitem/index.html", category="slack-workitem", icon="SlackPostMessageToChannel.png", parameters={@WidParameter(name="ChannelName", required=true), @WidParameter(name="Message", required=true)}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="slack-workitem", version="7.43.0.Final")}, serviceInfo=@WidService(category="Slack", description="Post messages and add reminders using Slack", keywords="slack,message,send,channel", action=@WidAction(title="Send message to a Slack channel"), authinfo=@WidAuth(required=true, params={"accessToken"}, paramsdescription={"Slack access token"}, referencesite="https://api.slack.com/tokens")))
public class PostMessageToChannelWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String accessToken;
    private SlackAuth auth = new SlackAuth();

    public PostMessageToChannelWorkitemHandler(String accessToken) {
        this.accessToken = accessToken;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            String channelName = (String)workItem.getParameter("ChannelName");
            String message = (String)workItem.getParameter("Message");
            boolean foundChannel = false;
            ChannelsListResponse channelListResponse = this.auth.authChannelListRequest(this.accessToken);
            List channelList = channelListResponse.getChannels();
            for (Channel channel : channelList) {
                if (!channel.getName().equals(channelName)) continue;
                this.auth.authChatPostMessageRequest(channel.getId(), this.accessToken, message);
                foundChannel = true;
            }
            if (!foundChannel) {
                throw new IllegalArgumentException("Unable to find channel: " + channelName);
            }
            workItemManager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(SlackAuth auth) {
        this.auth = auth;
    }
}

