/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.PomEnhancer;
import org.guvnor.common.services.project.backend.server.utils.POMContentHandler;
import org.guvnor.common.services.project.events.ModuleUpdatedEvent;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.MavenRepository;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.m2repo.service.M2RepoService;
import org.jboss.errai.bus.server.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.annotations.Customizable;
import org.uberfire.backend.server.cdi.workspace.WorkspaceScoped;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mvp.Command;

@Service
@WorkspaceScoped
public class POMServiceImpl
implements POMService {
    public static final String POM_XML = "pom.xml";
    private final Logger logger = LoggerFactory.getLogger(POMServiceImpl.class);
    private IOService ioService;
    private POMContentHandler pomContentHandler;
    private M2RepoService m2RepoService;
    private MetadataService metadataService;
    private Event<ModuleUpdatedEvent> moduleUpdatedEvent;
    private ModuleService<? extends Module> moduleService;
    private MavenXpp3Writer writer;
    private PomEnhancer pomEnhancer;
    private CommentedOptionFactory optionsFactory;

    public POMServiceImpl() {
    }

    @Inject
    public POMServiceImpl(@Named(value="ioStrategy") IOService ioService, POMContentHandler pomContentHandler, M2RepoService m2RepoService, MetadataService metadataService, Event<ModuleUpdatedEvent> moduleUpdatedEvent, ModuleService<? extends Module> moduleService, CommentedOptionFactory optionsFactory, @Customizable PomEnhancer pomEnhancer) {
        this.ioService = ioService;
        this.pomContentHandler = pomContentHandler;
        this.m2RepoService = m2RepoService;
        this.metadataService = metadataService;
        this.moduleUpdatedEvent = moduleUpdatedEvent;
        this.moduleService = moduleService;
        this.optionsFactory = optionsFactory;
        this.writer = new MavenXpp3Writer();
        this.pomEnhancer = pomEnhancer;
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path projectRoot, POM pomModel) {
        Path pathToPOMXML = null;
        try {
            pomModel.addRepository(this.getRepository());
            pathToPOMXML = Paths.convert((org.uberfire.backend.vfs.Path)projectRoot).resolve(POM_XML);
            if (this.ioService.exists(pathToPOMXML)) {
                throw new FileAlreadyExistsException(pathToPOMXML.toString());
            }
            this.write(this.pomEnhancer.execute(this.pomContentHandler.convert(pomModel)), pathToPOMXML, this.ioService);
            return Paths.convert((Path)pathToPOMXML);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private MavenRepository getRepository() {
        MavenRepository mavenRepository = new MavenRepository();
        mavenRepository.setId("guvnor-m2-repo");
        mavenRepository.setName("Guvnor M2 Repo");
        mavenRepository.setUrl(this.m2RepoService.getRepositoryURL());
        return mavenRepository;
    }

    private void write(Model model, Path pathToPOMXML, IOService ioService) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.writer.write((OutputStream)baos, model);
            ioService.write(pathToPOMXML, new String(baos.toByteArray(), StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public POM load(org.uberfire.backend.vfs.Path pomPath) {
        try {
            return this.pomContentHandler.toModel(this.loadPomXMLString(pomPath));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private String loadPomXMLString(org.uberfire.backend.vfs.Path pomPath) {
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)pomPath);
        return this.ioService.readAllString(nioPath);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path pomPath, POM pom, Metadata metadata, String comment) {
        return this.save(pomPath, pom, metadata, comment, false);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path pomPath, POM pom, Metadata metadata, String comment, boolean updateModules) {
        return new PomSaver(pomPath, pom, metadata, comment).savePOM(updateModules);
    }

    private class PomSaver {
        private final org.uberfire.backend.vfs.Path pomPath;
        private final POM pom;
        private final Metadata metadata;
        private String comment;
        private List<Command> updates = new ArrayList<Command>();

        public PomSaver(org.uberfire.backend.vfs.Path pomPath, POM pom, Metadata metadata, String comment) {
            this.pomPath = pomPath;
            this.pom = pom;
            this.metadata = metadata;
            this.comment = comment;
        }

        public org.uberfire.backend.vfs.Path savePOM(boolean updateModules) {
            try {
                POMServiceImpl.this.ioService.startBatch(Paths.convert((org.uberfire.backend.vfs.Path)this.pomPath).getFileSystem(), new Option[]{POMServiceImpl.this.optionsFactory.makeCommentedOption(this.comment != null ? this.comment : "")});
                this.savePOM();
                if (updateModules) {
                    this.saveSubModulePOMs();
                }
                org.uberfire.backend.vfs.Path path = this.pomPath;
                return path;
            }
            catch (Exception e) {
                throw ExceptionUtilities.handleException((Exception)e);
            }
            finally {
                POMServiceImpl.this.ioService.endBatch();
                for (Command update : this.updates) {
                    update.execute();
                }
            }
        }

        private void savePOM() throws IOException, XmlPullParserException {
            this.savePOM(this.pomPath, this.pom, this.metadata);
        }

        private void savePOM(org.uberfire.backend.vfs.Path pomPath, POM pom, Metadata metadata) throws IOException, XmlPullParserException {
            Optional<Module> oldModuleForUpdateEvent = this.getModuleIfPomHasChanges(pomPath, pom);
            if (metadata == null) {
                POMServiceImpl.this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)pomPath), POMServiceImpl.this.pomContentHandler.toString(pom, POMServiceImpl.this.loadPomXMLString(pomPath)), new OpenOption[0]);
            } else {
                POMServiceImpl.this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)pomPath), POMServiceImpl.this.pomContentHandler.toString(pom, POMServiceImpl.this.loadPomXMLString(pomPath)), POMServiceImpl.this.metadataService.setUpAttributes(pomPath, metadata), new OpenOption[0]);
            }
            if (oldModuleForUpdateEvent.isPresent()) {
                this.updates.add(() -> POMServiceImpl.this.moduleUpdatedEvent.fire((Object)new ModuleUpdatedEvent((Module)oldModuleForUpdateEvent.get(), POMServiceImpl.this.moduleService.resolveModule(pomPath))));
            }
        }

        private Optional<Module> getModuleIfPomHasChanges(org.uberfire.backend.vfs.Path pomPath, POM pom) {
            POM load = POMServiceImpl.this.load(pomPath);
            if (!load.equals((Object)pom)) {
                return Optional.of(POMServiceImpl.this.moduleService.resolveModule(pomPath));
            }
            return Optional.empty();
        }

        private void saveSubModulePOMs() throws IOException, XmlPullParserException {
            if (this.pom.isMultiModule() && this.pom.getModules() != null) {
                for (String childModuleName : this.pom.getModules()) {
                    this.saveGAVChange(this.pom.getGav(), childModuleName);
                }
            }
        }

        private void saveGAVChange(GAV gav, String childModuleName) throws IOException, XmlPullParserException {
            POM childContent;
            Path childPOMPath = Paths.convert((org.uberfire.backend.vfs.Path)this.pomPath).getParent().resolve(childModuleName).resolve(POMServiceImpl.POM_XML);
            if (POMServiceImpl.this.ioService.exists(childPOMPath) && (childContent = POMServiceImpl.this.load(Paths.convert((Path)childPOMPath))) != null) {
                childContent.setParent(gav);
                childContent.getGav().setGroupId(gav.getGroupId());
                childContent.getGav().setVersion(gav.getVersion());
                this.savePOM(Paths.convert((Path)childPOMPath), childContent, null);
            }
        }
    }
}

