/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security.adapter;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.uberfire.backend.server.security.RoleRegistry;
import org.uberfire.security.authz.adapter.GroupsAdapter;
import org.uberfire.security.backend.BasicAuthorizationPrincipal;

public class GroupAdapterAuthorizationSource {
    private final String roleRegexTemplate = System.getProperty("org.uberfire.regex.role_mapper", null);
    private HashMap<String, Pattern> regexPatterns = new HashMap();
    private List<GroupsAdapter> groupsAdapters = GroupAdapterAuthorizationSource.loadGroupAdapters();

    private static synchronized List<GroupsAdapter> loadGroupAdapters() {
        ServiceLoader<GroupsAdapter> providers = ServiceLoader.load(GroupsAdapter.class);
        if (providers == null) {
            return Collections.emptyList();
        }
        ArrayList<GroupsAdapter> result = new ArrayList<GroupsAdapter>();
        for (GroupsAdapter provider : providers) {
            result.add(provider);
        }
        return Collections.unmodifiableList(result);
    }

    protected List<String> loadEntitiesFromSubjectAndAdapters(String username, Subject subject, String[] rolePrincipleNames) {
        ArrayList<String> roles = new ArrayList<String>();
        try {
            List<String> principals = this.collectEntitiesFromSubject(username, subject, rolePrincipleNames);
            roles.addAll(this.filterValidPrincipals(principals));
            List<String> principalsFromAdapters = this.collectEntitiesFromAdapters(username, subject);
            roles.addAll(this.filterValidPrincipals(principalsFromAdapters));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return roles;
    }

    protected List<String> collectEntitiesFromAdapters(String username, Subject subject) {
        HashSet userGroups = new HashSet();
        this.groupsAdapters.forEach(adapter -> {
            List groupRoles = adapter.getGroups(username, (Object)subject);
            if (groupRoles != null) {
                for (Group group : groupRoles) {
                    if (this.roleRegexTemplate == null || this.roleRegexTemplate.isEmpty()) {
                        userGroups.add(group.getName());
                        continue;
                    }
                    userGroups.add(this.getSimpleName(group.getName()));
                }
            }
        });
        return new LinkedList<String>(userGroups);
    }

    protected List<String> collectEntitiesFromSubject(String username, Subject subject, String[] rolePrincipleNames) {
        ArrayList<String> roles;
        block7: {
            if (null == subject) {
                return null;
            }
            roles = new ArrayList<String>();
            try {
                Set<Principal> principals = subject.getPrincipals();
                if (principals == null) break block7;
                for (Principal p : principals) {
                    if (p instanceof BasicAuthorizationPrincipal) continue;
                    if (p instanceof java.security.acl.Group) {
                        for (String rolePrincipleName : rolePrincipleNames) {
                            if (!rolePrincipleName.equalsIgnoreCase(p.getName())) continue;
                            Enumeration groups = ((java.security.acl.Group)p).members();
                            while (groups.hasMoreElements()) {
                                Principal groupPrincipal = (Principal)groups.nextElement();
                                roles.add(groupPrincipal.getName());
                            }
                        }
                        continue;
                    }
                    roles.add(p.getName());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return roles;
    }

    protected List<Role> getRoles(List<String> principals) {
        Set<Role> registeredRoles;
        if (null != principals && !principals.isEmpty() && null != (registeredRoles = RoleRegistry.get().getRegisteredRoles()) && !registeredRoles.isEmpty()) {
            LinkedList<Role> result = new LinkedList<Role>();
            for (String role : principals) {
                if (null == RoleRegistry.get().getRegisteredRole(role)) continue;
                result.add((Role)new RoleImpl(role));
            }
            return result;
        }
        return Collections.emptyList();
    }

    protected List<Group> getGroups(List<String> principals, String user) {
        Set<Role> registeredRoles;
        if (null != principals && !principals.isEmpty() && null != (registeredRoles = RoleRegistry.get().getRegisteredRoles()) && !registeredRoles.isEmpty()) {
            LinkedList<Group> result = new LinkedList<Group>();
            for (String role : principals) {
                if (role == user || null != RoleRegistry.get().getRegisteredRole(role)) continue;
                result.add((Group)new GroupImpl(role));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private List<String> filterValidPrincipals(List<String> principals) {
        if (principals == null) {
            return new ArrayList<String>();
        }
        return principals.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private String getSimpleName(String name) {
        for (Role role : RoleRegistry.get().getRegisteredRoles()) {
            if (!this.regexPatterns.containsKey(role.getName())) {
                this.regexPatterns.put(role.getName(), Pattern.compile(this.roleRegexTemplate.replaceAll("role", role.getName())));
            }
            Matcher matcher = this.regexPatterns.get(role.getName()).matcher(name);
            while (matcher.find()) {
                if (matcher.group(0) == null) continue;
                return role.getName();
            }
        }
        return name;
    }
}

