/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.util.gzip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;

class GzipResponseServletOutputStream
extends ServletOutputStream {
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private ByteArrayOutputStream baos;
    private GZIPOutputStream gzipStream;
    private HttpServletResponse response;
    private ServletOutputStream outputStream;
    private boolean closed = false;

    GzipResponseServletOutputStream(HttpServletResponse response) throws IOException {
        this.response = response;
        this.outputStream = response.getOutputStream();
        this.baos = new ByteArrayOutputStream();
        this.gzipStream = new GZIPOutputStream(this.baos);
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.gzipStream.finish();
        byte[] bytes = this.baos.toByteArray();
        this.response.addHeader(CONTENT_LENGTH_HEADER, Integer.toString(bytes.length));
        this.response.addHeader(CONTENT_ENCODING_HEADER, "gzip");
        this.outputStream.write(bytes);
        this.outputStream.flush();
        this.outputStream.close();
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.closed) {
            return;
        }
        this.gzipStream.flush();
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Output stream already closed.");
        }
        this.gzipStream.write((byte)b);
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("Output stream already closed.");
        }
        this.gzipStream.write(data, offset, length);
    }

    public boolean isReady() {
        return true;
    }

    public void setWriteListener(WriteListener writeListener) {
    }
}

