/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.editor.backend.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.guvnor.common.services.project.model.Module;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.forms.editor.service.shared.ModuleFormFinderService;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.model.JavaFormModel;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.kie.workbench.common.forms.services.backend.util.VFSScanner;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@Dependent
@Service
public class ModuleFormFinderServiceImpl
implements ModuleFormFinderService {
    private static final Logger logger = LoggerFactory.getLogger(ModuleFormFinderServiceImpl.class);
    private IOService ioService;
    private KieModuleService moduleService;
    private FormDefinitionSerializer serializer;
    private BuildInfoService buildInfoService;

    @Inject
    public ModuleFormFinderServiceImpl(@Named(value="ioStrategy") IOService ioService, KieModuleService moduleService, FormDefinitionSerializer serializer, BuildInfoService buildInfoService) {
        this.ioService = ioService;
        this.moduleService = moduleService;
        this.serializer = serializer;
        this.buildInfoService = buildInfoService;
    }

    public List<FormDefinition> findAllForms(org.uberfire.backend.vfs.Path path) {
        return this.findForms(path, formDefinition -> true);
    }

    public List<FormDefinition> findFormsForType(String typeName, org.uberfire.backend.vfs.Path path) {
        return this.findForms(path, formDefinition -> this.formByType((FormDefinition)formDefinition, typeName));
    }

    private boolean formByType(FormDefinition formDefinition, String typeName) {
        if (formDefinition.getModel() instanceof JavaFormModel) {
            return ((JavaFormModel)formDefinition.getModel()).getType().equals(typeName);
        }
        return false;
    }

    public FormDefinition findFormById(String id, org.uberfire.backend.vfs.Path path) {
        List<FormDefinition> forms = this.findForms(path, formDefinition -> this.formById((FormDefinition)formDefinition, id));
        if (forms != null && !forms.isEmpty()) {
            return forms.get(0);
        }
        return null;
    }

    private boolean formById(FormDefinition formDefinition, String id) {
        return formDefinition.getId().equals(id);
    }

    private List<FormDefinition> findForms(org.uberfire.backend.vfs.Path path, Predicate<FormDefinition> predicate) {
        KieModule module = (KieModule)this.moduleService.resolveModule(path);
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)module.getRootPath());
        List moduleForms = VFSScanner.scan((IOService)this.ioService, (Path)nioPath, Collections.singleton("frm"), this::convert, predicate).stream().map(VFSScanner.ScanResult::getResource).filter(Objects::nonNull).collect(Collectors.toList());
        List moduleFormsIds = moduleForms.stream().map(FormDefinition::getId).collect(Collectors.toList());
        Map dependenciesForms = this.buildInfoService.getBuildInfo((Module)module).getKieModuleMetaDataIgnoringErrors().getForms();
        return dependenciesForms.values().stream().map(arg_0 -> ((FormDefinitionSerializer)this.serializer).deserialize(arg_0)).filter(predicate).filter(formDefinition -> !moduleFormsIds.contains(formDefinition)).collect(Collectors.toCollection(() -> moduleForms));
    }

    private FormDefinition convert(InputStream in) {
        try {
            String content = IOUtils.toString((InputStream)in, (Charset)Charset.defaultCharset());
            return this.serializer.deserialize(content);
        }
        catch (IOException e) {
            logger.warn("Cannot read parse form due to: ", (Throwable)e);
            return null;
        }
    }
}

