/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.dynamic.service.shared;

import java.util.HashMap;
import java.util.Map;
import org.kie.workbench.common.forms.dynamic.service.shared.FormRenderingContext;
import org.kie.workbench.common.forms.dynamic.service.shared.RenderMode;
import org.kie.workbench.common.forms.model.FormDefinition;

public abstract class AbstractFormRenderingContext<T>
implements FormRenderingContext<T> {
    protected String namespace;
    protected Map<String, FormDefinition> availableForms = new HashMap<String, FormDefinition>();
    protected String rootFormId;
    protected T model;
    protected FormRenderingContext parentContext;
    protected RenderMode renderMode = RenderMode.EDIT_MODE;

    public AbstractFormRenderingContext(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public FormDefinition getRootForm() {
        return this.availableForms.get(this.rootFormId);
    }

    @Override
    public void setRootForm(FormDefinition rootForm) {
        this.rootFormId = rootForm.getId();
        this.availableForms.put(this.rootFormId, rootForm);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setModel(T model) {
        this.model = model;
    }

    @Override
    public T getModel() {
        return this.model;
    }

    @Override
    public FormRenderingContext getParentContext() {
        return this.parentContext;
    }

    @Override
    public void setParentContext(FormRenderingContext parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public RenderMode getRenderMode() {
        return this.renderMode;
    }

    @Override
    public void setRenderMode(RenderMode renderMode) {
        this.renderMode = renderMode;
    }

    @Override
    public Map<String, FormDefinition> getAvailableForms() {
        return this.availableForms;
    }

    protected abstract AbstractFormRenderingContext<T> getNewInstance(String var1);

    @Override
    public FormRenderingContext getCopyFor(String namespace, String formKey, T model) {
        if (formKey == null || formKey.isEmpty()) {
            return null;
        }
        AbstractFormRenderingContext<T> copy = this.getNewInstance(namespace);
        copy.setRenderMode(this.renderMode);
        copy.setRootForm(this.availableForms.get(formKey));
        copy.setModel(model);
        copy.availableForms = this.availableForms;
        copy.setParentContext(this);
        return copy;
    }
}

