/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.utils.IOUtils;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="ArchiveDefinitions.wid", name="Archive", displayName="Archive", defaultHandler="mvel: new org.jbpm.process.workitem.archive.ArchiveWorkItemHandler()", documentation="archive-workitem/index.html", category="archive-workitem", icon="Archive.png", parameters={@WidParameter(name="Archive", required=true), @WidParameter(name="Files", runtimeType="java.util.List")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="archive-workitem", version="7.52.0.Final")}, serviceInfo=@WidService(category="Archive", description="Archive a list of files", keywords="archive,file,files,zip", action=@WidAction(title="Archive a list of files."), authinfo=@WidAuth))
public class ArchiveWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String archive = (String)workItem.getParameter("Archive");
        List files = (List)workItem.getParameter("Files");
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            FileOutputStream outputStream = new FileOutputStream(new File(archive));
            ArchiveOutputStream os = new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)outputStream);
            if (files != null) {
                for (File file : files) {
                    TarArchiveEntry entry = new TarArchiveEntry("testdata/test1.xml");
                    entry.setModTime(0L);
                    entry.setSize(file.length());
                    entry.setUserId(0);
                    entry.setGroupId(0);
                    entry.setMode(32768);
                    os.putArchiveEntry((ArchiveEntry)entry);
                    IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)os);
                }
            }
            os.closeArchiveEntry();
            os.close();
            manager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception e) {
            this.handleException(e);
            manager.abortWorkItem(workItem.getId());
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }
}

