/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.guvnor.common.services.backend.file.FileDiscoveryService;
import org.guvnor.common.services.project.builder.events.InvalidateDMOModuleCacheEvent;
import org.guvnor.common.services.project.builder.events.InvalidateDMOPackageCacheEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.kie.scanner.KieModuleMetaData;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.backend.file.EnumerationsFileFilter;
import org.kie.workbench.common.services.backend.file.GlobalsFileFilter;
import org.kie.workbench.common.services.datamodel.backend.server.builder.packages.PackageDataModelOracleBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.cache.LRUModuleDataModelOracleCache;
import org.kie.workbench.common.services.datamodel.spi.DataModelExtension;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
@Named(value="PackageDataModelOracleCache")
public class LRUDataModelOracleCache
extends LRUCache<Package, PackageDataModelOracle> {
    private static final DirectoryStream.Filter<Path> FILTER_ENUMERATIONS = new EnumerationsFileFilter();
    private static final DirectoryStream.Filter<Path> FILTER_GLOBALS = new GlobalsFileFilter();
    private IOService ioService;
    private FileDiscoveryService fileDiscoveryService;
    private LRUModuleDataModelOracleCache cacheModules;
    private KieModuleService moduleService;
    private BuildInfoService buildInfoService;
    private Instance<DataModelExtension> dataModelExtensionsProvider;
    private MVELEvaluator evaluator;

    public LRUDataModelOracleCache() {
    }

    @Inject
    public LRUDataModelOracleCache(@Named(value="ioStrategy") IOService ioService, FileDiscoveryService fileDiscoveryService, @Named(value="ModuleDataModelOracleCache") LRUModuleDataModelOracleCache cacheModules, KieModuleService moduleService, BuildInfoService buildInfoService, Instance<DataModelExtension> dataModelExtensionsProvider, MVELEvaluator evaluator) {
        this.ioService = ioService;
        this.fileDiscoveryService = fileDiscoveryService;
        this.cacheModules = cacheModules;
        this.moduleService = moduleService;
        this.buildInfoService = buildInfoService;
        this.dataModelExtensionsProvider = dataModelExtensionsProvider;
        this.evaluator = evaluator;
    }

    public void invalidatePackageCache(@Observes InvalidateDMOPackageCacheEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        org.uberfire.backend.vfs.Path resourcePath = event.getResourcePath();
        Package pkg = this.moduleService.resolvePackage(resourcePath);
        if (pkg != null) {
            this.invalidateCache(pkg);
        }
    }

    public void invalidateProjectPackagesCache(@Observes InvalidateDMOModuleCacheEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        org.uberfire.backend.vfs.Path resourcePath = event.getResourcePath();
        KieModule module = (KieModule)this.moduleService.resolveModule(resourcePath);
        if (module == null) {
            return;
        }
        String moduleUri = module.getRootPath().toURI();
        ArrayList<Package> cacheEntriesToInvalidate = new ArrayList<Package>();
        for (Package pkg : this.getKeys()) {
            org.uberfire.backend.vfs.Path packageMainSrcPath = pkg.getPackageMainSrcPath();
            org.uberfire.backend.vfs.Path packageTestSrcPath = pkg.getPackageTestSrcPath();
            org.uberfire.backend.vfs.Path packageMainResourcesPath = pkg.getPackageMainResourcesPath();
            org.uberfire.backend.vfs.Path packageTestResourcesPath = pkg.getPackageTestResourcesPath();
            if (packageMainSrcPath != null && packageMainSrcPath.toURI().startsWith(moduleUri)) {
                cacheEntriesToInvalidate.add(pkg);
                continue;
            }
            if (packageTestSrcPath != null && packageTestSrcPath.toURI().startsWith(moduleUri)) {
                cacheEntriesToInvalidate.add(pkg);
                continue;
            }
            if (packageMainResourcesPath != null && packageMainResourcesPath.toURI().startsWith(moduleUri)) {
                cacheEntriesToInvalidate.add(pkg);
                continue;
            }
            if (packageTestResourcesPath == null || !packageTestResourcesPath.toURI().startsWith(moduleUri)) continue;
            cacheEntriesToInvalidate.add(pkg);
        }
        for (Package pkg : cacheEntriesToInvalidate) {
            this.invalidateCache(pkg);
        }
    }

    public PackageDataModelOracle assertPackageDataModelOracle(KieModule module, Package pkg) {
        PackageDataModelOracle oracle = (PackageDataModelOracle)this.getEntry(pkg);
        if (oracle == null) {
            oracle = this.makePackageDataModelOracle(module, pkg);
            this.setEntry(pkg, oracle);
        }
        return oracle;
    }

    private PackageDataModelOracle makePackageDataModelOracle(KieModule module, Package pkg) {
        String packageName = pkg.getPackageName();
        PackageDataModelOracleBuilder dmoBuilder = PackageDataModelOracleBuilder.newPackageOracleBuilder(this.evaluator, packageName);
        ModuleDataModelOracle moduleOracle = this.cacheModules.assertModuleDataModelOracle(module);
        dmoBuilder.setModuleOracle(moduleOracle);
        this.loadEnumsForPackage(dmoBuilder, module, pkg);
        this.loadExtensionsForPackage(dmoBuilder, pkg);
        this.loadGlobalsForPackage(dmoBuilder, pkg);
        return dmoBuilder.build();
    }

    private void loadEnumsForPackage(PackageDataModelOracleBuilder dmoBuilder, KieModule module, Package pkg) {
        org.kie.api.builder.KieModule kieModule = this.buildInfoService.getBuildInfo((Module)module).getKieModuleIgnoringErrors();
        ClassLoader classLoader = KieModuleMetaData.Factory.newKieModuleMetaData((org.kie.api.builder.KieModule)kieModule).getClassLoader();
        Path nioPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)pkg.getPackageMainResourcesPath());
        Collection enumFiles = this.fileDiscoveryService.discoverFiles(nioPackagePath, FILTER_ENUMERATIONS);
        for (Path path : enumFiles) {
            String enumDefinition = this.ioService.readAllString(path);
            dmoBuilder.addEnum(enumDefinition, classLoader);
        }
    }

    private void loadExtensionsForPackage(PackageDataModelOracleBuilder dmoBuilder, Package pkg) {
        Path nioPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)pkg.getPackageMainResourcesPath());
        List extensions = StreamSupport.stream(this.dataModelExtensionsProvider.spliterator(), false).collect(Collectors.toList());
        for (DataModelExtension extension : extensions) {
            DirectoryStream.Filter filter = extension.getFilter();
            Collection extensionFiles = this.fileDiscoveryService.discoverFiles(nioPackagePath, filter);
            extensionFiles.stream().map(file -> extension.getExtensions(file, this.ioService.readAllString(file))).forEach(mappings -> mappings.forEach(mapping -> dmoBuilder.addExtension(mapping.getKind(), mapping.getValues())));
        }
    }

    private void loadGlobalsForPackage(PackageDataModelOracleBuilder dmoBuilder, Package pkg) {
        Path nioPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)pkg.getPackageMainResourcesPath());
        Collection globalFiles = this.fileDiscoveryService.discoverFiles(nioPackagePath, FILTER_GLOBALS);
        for (Path path : globalFiles) {
            String definition = this.ioService.readAllString(path);
            dmoBuilder.addGlobals(definition);
        }
    }
}

