/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.util;

import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

public class ParentTypesMatcher {
    private final Supplier<DefinitionManager> definitionManagerSupplier;
    private final Function<Node, Element> parentSupplier;
    private final Set<String> typeIds;

    public ParentTypesMatcher(Supplier<DefinitionManager> definitionManagerSupplier, Function<Node, Element> parentSupplier, Class<?>[] types) {
        this.definitionManagerSupplier = definitionManagerSupplier;
        this.parentSupplier = parentSupplier;
        this.typeIds = Stream.of(types).map(BindableAdapterUtils::getDefinitionId).collect(Collectors.toSet());
    }

    public BiPredicate<Node<? extends View<?>, ? extends Edge>, Node<? extends View<?>, ? extends Edge>> matcher() {
        return this::match;
    }

    private boolean match(Node<? extends View<?>, ? extends Edge> nodeA, Node<? extends View<?>, ? extends Edge> nodeB) {
        if (nodeA == null && nodeB != null || nodeB == null && nodeA != null) {
            return true;
        }
        Optional<Element<? extends Definition>> parentA = this.getAnySupportedParent((Element<? extends Definition<?>>)nodeA);
        Optional<Element<? extends Definition>> parentB = this.getAnySupportedParent((Element<? extends Definition<?>>)nodeB);
        return parentA.equals(parentB);
    }

    private Optional<Element<? extends Definition>> getAnySupportedParent(Element<? extends Definition<?>> candidate) {
        if (null != candidate && null != candidate.asNode()) {
            Node node = candidate.asNode();
            return GraphUtils.getParentByDefinitionId(this.definitionManagerSupplier.get(), this.parentSupplier, node, this.typeIds::contains);
        }
        return Optional.empty();
    }
}

