/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.util;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.soup.commons.util.Maps;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.HasInheritance;
import org.kie.workbench.common.stunner.core.definition.adapter.MorphAdapter;
import org.kie.workbench.common.stunner.core.definition.clone.ClonePolicy;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes;
import org.kie.workbench.common.stunner.core.definition.property.PropertyType;
import org.kie.workbench.common.stunner.core.definition.property.type.BooleanType;
import org.kie.workbench.common.stunner.core.definition.property.type.DoubleType;
import org.kie.workbench.common.stunner.core.definition.property.type.IntegerType;
import org.kie.workbench.common.stunner.core.definition.property.type.StringType;
import org.kie.workbench.common.stunner.core.factory.graph.EdgeFactory;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.kie.workbench.common.stunner.core.factory.graph.NodeFactory;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.registry.factory.FactoryRegistry;
import org.kie.workbench.common.stunner.core.registry.impl.DefinitionsCacheRegistry;

@ApplicationScoped
public class DefinitionUtils {
    private final DefinitionManager definitionManager;
    private final DefinitionsCacheRegistry definitionsRegistry;
    private static final Map<Class<?>, Class<? extends PropertyType>> DEFAULT_PROPERTY_TYPES = new Maps.Builder().put(String.class, StringType.class).put(Double.class, DoubleType.class).put(Integer.class, IntegerType.class).put(Boolean.class, BooleanType.class).build();

    protected DefinitionUtils() {
        this(null, null);
    }

    @Inject
    public DefinitionUtils(DefinitionManager definitionManager, DefinitionsCacheRegistry definitionsRegistry) {
        this.definitionManager = definitionManager;
        this.definitionsRegistry = definitionsRegistry;
    }

    public <T> String getName(T definition) {
        DefinitionAdapter definitionAdapter = this.definitionManager.adapters().registry().getDefinitionAdapter(definition.getClass());
        String nameField = definitionAdapter.getMetaPropertyField(definition, PropertyMetaTypes.NAME);
        if (null != nameField) {
            Object name = definitionAdapter.getProperty(definition, nameField).get();
            return this.getPropertyValueAsString(name);
        }
        return null;
    }

    public <T> String getNameIdentifier(T definition) {
        return this.definitionManager.adapters().forDefinition().getMetaPropertyField(definition, PropertyMetaTypes.NAME);
    }

    private String getPropertyValueAsString(Object property) {
        return Optional.ofNullable(this.definitionManager.adapters().forProperty().getValue(property)).map(String::valueOf).orElse("");
    }

    public String getTitle(String definitionId) {
        return this.definitionManager.adapters().forDefinition().getTitle(this.definitionsRegistry.getDefinitionById(definitionId));
    }

    public Bounds buildBounds(Object definition, double x, double y) {
        DefinitionAdapter adapter = this.definitionManager.adapters().registry().getDefinitionAdapter(definition.getClass());
        String radiusField = adapter.getMetaPropertyField(definition, PropertyMetaTypes.RADIUS);
        Double width = null;
        Double height = null;
        if (null != radiusField) {
            Double rv;
            Optional hasRadius = adapter.getProperty(definition, radiusField);
            if (hasRadius.isPresent() && null != (rv = (Double)this.definitionManager.adapters().forProperty().getValue(hasRadius.get()))) {
                height = width = Double.valueOf(rv * 2.0);
            }
        } else {
            String wField = adapter.getMetaPropertyField(definition, PropertyMetaTypes.WIDTH);
            String hField = adapter.getMetaPropertyField(definition, PropertyMetaTypes.HEIGHT);
            if (null != wField && null != hField) {
                Optional hasWitdth = adapter.getProperty(definition, wField);
                Optional hasHeight = adapter.getProperty(definition, hField);
                if (hasWitdth.isPresent() && hasHeight.isPresent()) {
                    width = (Double)this.definitionManager.adapters().forProperty().getValue(hasWitdth.get());
                    height = (Double)this.definitionManager.adapters().forProperty().getValue(hasHeight.get());
                }
            }
        }
        double _width = null != width ? width : 0.0;
        double _height = null != height ? height : 0.0;
        return Bounds.create((double)x, (double)y, (double)(x + _width), (double)(y + _height));
    }

    public <T> MorphDefinition getMorphDefinition(T definition) {
        MorphAdapter adapter = this.definitionManager.adapters().registry().getMorphAdapter(definition.getClass());
        Iterable definitions = adapter.getMorphDefinitions(definition);
        if (null != definitions && definitions.iterator().hasNext()) {
            return (MorphDefinition)definitions.iterator().next();
        }
        return null;
    }

    public boolean hasMorphTargets(Object definition) {
        MorphAdapter morphAdapter = this.definitionManager.adapters().registry().getMorphAdapter(definition.getClass());
        Iterable morphDefinitions = morphAdapter.getMorphDefinitions(definition);
        if (null != morphDefinitions && morphDefinitions.iterator().hasNext()) {
            for (MorphDefinition morphDefinition : morphDefinitions) {
                Iterable morphTargets = morphAdapter.getTargets(definition, morphDefinition);
                if (null == morphTargets || !morphTargets.iterator().hasNext()) continue;
                return true;
            }
        }
        return false;
    }

    public String getDefinitionSetId(Class<?> type) {
        return this.definitionManager.adapters().forDefinitionSet().getId(this.definitionManager.definitionSets().getDefinitionSetByType(type));
    }

    public <T> String[] getDefinitionIds(T definition) {
        Class<?> type = definition.getClass();
        DefinitionAdapter definitionAdapter = this.definitionManager.adapters().registry().getDefinitionAdapter(type);
        String definitionId = definitionAdapter.getId(definition).value();
        String baseId = null;
        if (definitionAdapter instanceof HasInheritance) {
            baseId = ((HasInheritance)definitionAdapter).getBaseType(type);
        }
        return new String[]{definitionId, baseId};
    }

    public boolean isAllPolicy(MorphDefinition definition) {
        return ClonePolicy.ALL.equals((Object)definition.getPolicy());
    }

    public boolean isNonePolicy(MorphDefinition definition) {
        return ClonePolicy.NONE.equals((Object)definition.getPolicy());
    }

    public boolean isDefaultPolicy(MorphDefinition definition) {
        return ClonePolicy.DEFAULT.equals((Object)definition.getPolicy());
    }

    public Annotation getQualifier(String defSetId) {
        PortablePreconditions.checkNotNull((String)"defSetId", (Object)defSetId);
        Object ds = this.definitionManager.definitionSets().getDefinitionSetById(defSetId);
        return this.getQualifier(ds);
    }

    private Annotation getQualifier(Object ds) {
        return this.definitionManager.adapters().forDefinitionSet().getQualifier(ds);
    }

    public static boolean isNodeFactory(Class<? extends ElementFactory> graphFactoryClass, FactoryRegistry registry) {
        if (!graphFactoryClass.equals(NodeFactory.class)) {
            ElementFactory factory = registry.getElementFactory(graphFactoryClass);
            return factory instanceof NodeFactory;
        }
        return true;
    }

    public static boolean isEdgeFactory(Class<? extends ElementFactory> graphFactoryClass, FactoryRegistry registry) {
        if (!graphFactoryClass.equals(EdgeFactory.class)) {
            ElementFactory factory = registry.getElementFactory(graphFactoryClass);
            return factory instanceof EdgeFactory;
        }
        return true;
    }

    public DefinitionManager getDefinitionManager() {
        return this.definitionManager;
    }

    public static Class<? extends PropertyType> getDefaultPropertyType(Class<?> clazz) {
        return DEFAULT_PROPERTY_TYPES.get(clazz);
    }

    public static Object getElementDefinition(Element element) {
        if (element != null && element.getContent() instanceof Definition) {
            return ((Definition)element.getContent()).getDefinition();
        }
        return null;
    }
}

