/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.archetype.mgmt.client.table.item;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLLIElement;
import elemental2.dom.HTMLTableCellElement;
import javax.inject.Inject;
import javax.inject.Named;
import org.gwtbootstrap3.client.ui.ModalSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.archetype.mgmt.client.table.item.ArchetypeItemPresenter;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.mvp.Command;

@Templated(value="#archetype-item-root")
public class ArchetypeItemView
implements ArchetypeItemPresenter.View {
    private static final String LI_DISABLED_CLASS = "li-disabled";
    private ArchetypeItemPresenter presenter;
    private YesNoCancelPopup deleteConfirmationPopup;
    @Inject
    @Named(value="td")
    @DataField(value="cell-include")
    private HTMLTableCellElement cellInclude;
    @Inject
    @Named(value="td")
    @DataField(value="cell-kebab-actions")
    private HTMLTableCellElement cellKebabActions;
    @Inject
    @Named(value="td")
    @DataField(value="cell-status")
    private HTMLTableCellElement cellStatus;
    @Inject
    @DataField(value="include")
    private HTMLInputElement includeCheckbox;
    @Inject
    @Named(value="span")
    @DataField(value="group-id")
    private HTMLElement groupId;
    @Inject
    @Named(value="span")
    @DataField(value="artifact-id")
    private HTMLElement artifactId;
    @Inject
    @Named(value="span")
    @DataField(value="version")
    private HTMLElement version;
    @Inject
    @Named(value="span")
    @DataField(value="created-date")
    private HTMLElement createdDate;
    @Inject
    @DataField(value="status-valid")
    private HTMLDivElement statusValid;
    @Inject
    @DataField(value="status-invalid")
    private HTMLDivElement statusInvalid;
    @Inject
    @DataField(value="actions-delete")
    private HTMLLIElement deleteButton;
    @Inject
    @DataField(value="actions-validate")
    private HTMLLIElement validateButton;
    @Inject
    @DataField(value="actions-set-as-default")
    private HTMLLIElement setAsDefaultButton;
    @Inject
    @DataField(value="default-badge")
    private HTMLDivElement defaultBadge;
    @Inject
    private TranslationService ts;

    public void init(ArchetypeItemPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setIncluded(boolean isIncluded) {
        this.includeCheckbox.checked = isIncluded;
    }

    @Override
    public void showInclude(boolean isVisible) {
        this.cellInclude.hidden = !isVisible;
    }

    @Override
    public void showStatus(boolean isVisible) {
        this.cellStatus.hidden = !isVisible;
    }

    @Override
    public void setGroupId(String groupId) {
        this.groupId.textContent = groupId;
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.artifactId.textContent = artifactId;
    }

    @Override
    public void setVersion(String version) {
        this.version.textContent = version;
    }

    @Override
    public void setCreatedDate(String createdDate) {
        this.createdDate.textContent = createdDate;
    }

    @Override
    public void showInvalidStatus(boolean isVisible) {
        this.statusInvalid.hidden = !isVisible;
    }

    @Override
    public void setInvalidTooltip(String message) {
        this.statusInvalid.title = message;
    }

    @Override
    public void showValidStatus(boolean isVisible) {
        this.statusValid.hidden = !isVisible;
    }

    @Override
    public void setValidTooltip(String message) {
        this.statusValid.title = message;
    }

    @Override
    public void setDeleteCommand(Command deleteCommand) {
        this.createDeleteConfirmationPopup(deleteCommand);
    }

    @Override
    public void showDeleteAction(boolean isVisible) {
        this.deleteButton.hidden = !isVisible;
    }

    @Override
    public void showValidateAction(boolean isVisible) {
        this.validateButton.hidden = !isVisible;
    }

    @Override
    public void showDefaultBadge(boolean isVisible) {
        this.defaultBadge.hidden = !isVisible;
    }

    @Override
    public void setDefaultBadgeTooltip(String message) {
        this.defaultBadge.title = message;
    }

    @Override
    public void enableIncludeCheckbox(boolean isEnabled) {
        this.includeCheckbox.disabled = !isEnabled;
    }

    @Override
    public void enableSetDefault(boolean isEnabled) {
        if (isEnabled) {
            this.setAsDefaultButton.classList.remove(new String[]{LI_DISABLED_CLASS});
        } else {
            this.setAsDefaultButton.classList.add(new String[]{LI_DISABLED_CLASS});
        }
    }

    @Override
    public void checkIncluded(boolean isChecked) {
        this.includeCheckbox.checked = isChecked;
    }

    private void createDeleteConfirmationPopup(Command deleteCommand) {
        String title = this.ts.getTranslation("ArchetypeManagement.DeleteArchetypeTitle");
        String message = this.ts.getTranslation("ArchetypeManagement.DeleteArchetypeMessage");
        String cancelLabel = this.ts.getTranslation("ArchetypeManagement.Cancel");
        String deleteLabel = this.ts.getTranslation("ArchetypeManagement.Delete");
        this.deleteConfirmationPopup = YesNoCancelPopup.newYesNoCancelPopup((String)title, (String)message, null, null, null, () -> {}, (String)cancelLabel, (ButtonType)ButtonType.DEFAULT, (Command)deleteCommand, (String)deleteLabel, (ButtonType)ButtonType.DANGER);
        this.deleteConfirmationPopup.setSize(ModalSize.MEDIUM);
        this.deleteConfirmationPopup.clearScrollHeight();
    }

    @EventHandler(value={"actions-delete"})
    public void onDeleteButtonClicked(ClickEvent event) {
        this.deleteConfirmationPopup.show();
    }

    @EventHandler(value={"actions-validate"})
    public void onValidateButtonClicked(ClickEvent event) {
        this.presenter.validate();
    }

    @EventHandler(value={"actions-set-as-default"})
    public void onSetAsDefaultButtonClicked(ClickEvent event) {
        this.presenter.makeDefault();
    }

    @EventHandler(value={"include"})
    public void onIncludeChanged(ChangeEvent event) {
        this.presenter.setIncluded(this.includeCheckbox.checked);
    }
}

