/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.archetype.mgmt.client.table.presenters;

import elemental2.dom.Element;
import elemental2.promise.IThenable;
import elemental2.promise.Promise;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.archetype.mgmt.client.modal.AddArchetypeModalPresenter;
import org.kie.workbench.common.screens.archetype.mgmt.client.table.config.ArchetypeTableConfiguration;
import org.kie.workbench.common.screens.archetype.mgmt.client.table.item.ArchetypeItemPresenter;
import org.kie.workbench.common.screens.archetype.mgmt.client.table.item.model.ArchetypeItem;
import org.kie.workbench.common.screens.archetype.mgmt.client.table.presenters.ArchetypeTablePresenter;
import org.kie.workbench.common.screens.archetype.mgmt.shared.events.ArchetypeListUpdatedEvent;
import org.kie.workbench.common.screens.archetype.mgmt.shared.model.Archetype;
import org.kie.workbench.common.screens.archetype.mgmt.shared.model.PaginatedArchetypeList;
import org.kie.workbench.common.screens.archetype.mgmt.shared.preferences.ArchetypePreferences;
import org.kie.workbench.common.screens.archetype.mgmt.shared.services.ArchetypeService;
import org.kie.workbench.common.widgets.client.widget.ListPresenter;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.client.promise.Promises;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeFactory;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;

public abstract class AbstractArchetypeTablePresenter
implements ArchetypeTablePresenter,
HasBusyIndicator {
    protected static final String EMPTY = "";
    protected static final int PAGE_SIZE = 10;
    protected final View view;
    protected final ArchetypeListPresenter archetypeListPresenter;
    protected final BusyIndicatorView busyIndicatorView;
    protected final TranslationService ts;
    protected final AddArchetypeModalPresenter addArchetypeModalPresenter;
    protected final ArchetypePreferences archetypePreferences;
    protected final Caller<ArchetypeService> archetypeService;
    protected final PreferenceScopeFactory preferenceScopeFactory;
    protected final Promises promises;
    protected String searchFilter = "";
    protected int currentPage;
    protected int totalPages;
    protected ArchetypeTableConfiguration configuration;
    private boolean setup;
    private Runnable onChangedCallback;

    public AbstractArchetypeTablePresenter(View view, ArchetypeListPresenter archetypeListPresenter, BusyIndicatorView busyIndicatorView, TranslationService ts, AddArchetypeModalPresenter addArchetypeModalPresenter, ArchetypePreferences archetypePreferences, Caller<ArchetypeService> archetypeService, PreferenceScopeFactory preferenceScopeFactory, Promises promises) {
        this.view = view;
        this.archetypeListPresenter = archetypeListPresenter;
        this.busyIndicatorView = busyIndicatorView;
        this.ts = ts;
        this.addArchetypeModalPresenter = addArchetypeModalPresenter;
        this.archetypePreferences = archetypePreferences;
        this.archetypeService = archetypeService;
        this.preferenceScopeFactory = preferenceScopeFactory;
        this.promises = promises;
    }

    public void onArchetypeListUpdatedEvent(@Observes ArchetypeListUpdatedEvent event) {
        if (this.isSetup()) {
            this.loadList(false);
        }
    }

    public abstract Promise<Void> makeDefaultValue(String var1, boolean var2);

    public abstract Promise<Void> loadPreferences(PaginatedArchetypeList var1);

    public abstract boolean canMakeChanges();

    public void showBusyIndicator(String message) {
        this.busyIndicatorView.showBusyIndicator(message);
    }

    public void hideBusyIndicator() {
        this.busyIndicatorView.hideBusyIndicator();
    }

    @Override
    public boolean isSetup() {
        return this.setup;
    }

    @Override
    public ArchetypePreferences getPreferences() {
        return this.archetypePreferences;
    }

    @Override
    public boolean isEmpty() {
        return !this.isSetup() || this.archetypeListPresenter.getObjectsList().isEmpty();
    }

    @Override
    public void reset() {
        this.setup = false;
    }

    @Override
    public Promise<Void> setup(boolean isRefresh, Runnable onChangedCallback) {
        if (!isRefresh) {
            this.view.init(this);
            this.currentPage = 1;
            this.searchFilter = EMPTY;
            this.setup = true;
            this.onChangedCallback = onChangedCallback;
        }
        return this.loadList(isRefresh);
    }

    @Override
    public View getView() {
        return this.view;
    }

    public void setCurrentPage(int currentPage) {
        if (currentPage <= this.totalPages && currentPage > 0) {
            this.currentPage = currentPage;
            this.updateList();
        }
    }

    public void goToPreviousPage() {
        if (this.currentPage - 1 >= 1) {
            --this.currentPage;
            this.updateList();
        }
    }

    public void goToNextPage() {
        if (this.currentPage + 1 <= this.totalPages) {
            ++this.currentPage;
            this.updateList();
        }
    }

    public void goToFirstPage() {
        this.currentPage = 1;
        this.updateList();
    }

    public void goToLastPage() {
        this.currentPage = this.totalPages;
        this.updateList();
    }

    public void search(String searchText) {
        this.searchFilter = searchText;
        this.currentPage = 1;
        this.updateList();
    }

    public void addArchetype() {
        if (this.canMakeChanges()) {
            this.addArchetypeModalPresenter.show();
        }
    }

    public List<String> getIncluded() {
        return this.getSelectionMap().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public boolean isShowIncludeColumn() {
        return this.getConfiguration().isShowIncludeColumn();
    }

    public boolean isShowStatusColumn() {
        return this.getConfiguration().isShowStatusColumn();
    }

    public boolean isShowDeleteAction() {
        return this.getConfiguration().isShowDeleteAction();
    }

    public boolean isShowValidateAction() {
        return this.getConfiguration().isShowValidateAction();
    }

    public void setSelected(ArchetypeItem archetypeItem, boolean isSelected) {
        Map<String, Boolean> selectionMap = this.getSelectionMap();
        if (selectionMap.containsKey(archetypeItem.getArchetype().getAlias())) {
            this.getSelectionMap().put(archetypeItem.getArchetype().getAlias(), isSelected);
            this.updateSelectionCounter();
            this.runOnChangedCallback();
        }
    }

    public void updateSelectionCounter() {
        this.view.setSelectionCounter(this.ts.format("ArchetypeManagement.SelectionCounter", new Object[]{this.getIncluded().size(), this.getSelectionMap().size()}));
    }

    protected void runOnChangedCallback() {
        if (this.onChangedCallback != null) {
            this.onChangedCallback.run();
        }
    }

    protected ParameterizedCommand<ArchetypePreferences> loadPreferencesSuccessCallback(PaginatedArchetypeList paginatedList, Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<Void> resolve) {
        return preference -> {
            this.finishLoadList(paginatedList);
            resolve.onInvoke((IThenable)this.promises.resolve());
        };
    }

    protected ParameterizedCommand<Throwable> loadPreferencesErrorCallback(Promise.PromiseExecutorCallbackFn.RejectCallbackFn reject) {
        return error -> {
            this.hideBusyIndicator();
            reject.onInvoke(error);
        };
    }

    protected void configureView(PaginatedArchetypeList paginatedList) {
        this.view.showAddAction(this.getConfiguration().isShowAddAction());
        this.view.showIncludeHeader(this.getConfiguration().isShowIncludeColumn());
        this.view.showStatusHeader(this.getConfiguration().isShowStatusColumn());
        this.view.showSelectionCounter(this.getConfiguration().isShowIncludeColumn());
        boolean noResults = paginatedList.isEmpty();
        boolean noArchetypesRegistered = noResults && this.searchFilter.equals(EMPTY);
        this.view.showNoResults(noResults && !noArchetypesRegistered);
        this.view.showPagination(!noResults);
        this.view.showToolbar(!noArchetypesRegistered);
        this.view.showEmpty(noArchetypesRegistered);
    }

    public Promise<Void> savePreferences(PreferenceScope scope, boolean updateList) {
        if (this.canMakeChanges()) {
            this.showBusyIndicator(this.ts.getTranslation("ArchetypeManagement.Loading"));
            return this.promises.create((resolve, reject) -> this.archetypePreferences.save(scope, this.getSavePreferencesSuccessCallback(updateList, (Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<Void>)resolve), this.getSavePreferencesErrorCallback(reject)));
        }
        return this.promises.resolve();
    }

    public Promise<Void> savePreferences(PreferenceScopeResolutionStrategyInfo strategyInfo, boolean updateList) {
        if (this.canMakeChanges()) {
            this.showBusyIndicator(this.ts.getTranslation("ArchetypeManagement.Loading"));
            return this.promises.create((resolve, reject) -> this.archetypePreferences.save(strategyInfo, this.getSavePreferencesSuccessCallback(updateList), this.getSavePreferencesErrorCallback(reject)));
        }
        return this.promises.resolve();
    }

    protected void updateList() {
        this.loadList(true);
    }

    private Command getSavePreferencesSuccessCallback(boolean updateList, Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<Void> resolve) {
        return () -> {
            this.hideBusyIndicator();
            if (updateList) {
                this.updateList();
            }
            resolve.onInvoke((IThenable)this.promises.resolve());
        };
    }

    private ParameterizedCommand<Throwable> getSavePreferencesErrorCallback(Promise.PromiseExecutorCallbackFn.RejectCallbackFn reject) {
        return error -> {
            this.hideBusyIndicator();
            reject.onInvoke(error);
        };
    }

    protected void finishLoadList(PaginatedArchetypeList paginatedList) {
        List archetypeItems = paginatedList.getArchetypes().stream().map(archetype -> new ArchetypeItem((Archetype)archetype, this.getSelectionMap().get(archetype.getAlias()), archetype.getAlias().equals(this.archetypePreferences.getDefaultSelection()))).collect(Collectors.toList());
        this.archetypeListPresenter.setup(this.view.getTableBody(), archetypeItems, (property, presenter) -> presenter.setup((ArchetypeItem)property, this));
        this.updateSelectionCounter();
        this.hideBusyIndicator();
        this.view.show(true);
    }

    private Map<String, Boolean> getSelectionMap() {
        return this.archetypePreferences.getArchetypeSelectionMap();
    }

    private Command getSavePreferencesSuccessCallback(boolean updateList) {
        return () -> {
            this.hideBusyIndicator();
            if (updateList) {
                this.updateList();
            }
        };
    }

    protected Promise<Void> loadList(boolean isRefresh) {
        if (!isRefresh) {
            this.view.show(false);
        }
        this.showBusyIndicator(this.ts.getTranslation("ArchetypeManagement.Loading"));
        return this.promises.create((resolve, reject) -> ((ArchetypeService)this.archetypeService.call(paginatedList -> {
            this.setupCounters(paginatedList.getTotal());
            this.configureView((PaginatedArchetypeList)paginatedList);
            if (isRefresh) {
                this.finishLoadList((PaginatedArchetypeList)paginatedList);
                resolve.onInvoke((IThenable)this.promises.resolve());
            } else {
                resolve.onInvoke(this.loadPreferences((PaginatedArchetypeList)paginatedList));
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).list(Integer.valueOf(Math.max(0, this.currentPage - 1)), Integer.valueOf(10), this.searchFilter));
    }

    void setupCounters(int totalArchetypes) {
        this.currentPage = Math.max(1, this.currentPage);
        if (totalArchetypes < (this.currentPage - 1) * 10 + 1) {
            this.currentPage = totalArchetypes / 10;
        }
        int offset = (this.currentPage - 1) * 10;
        int fromCount = totalArchetypes > 0 ? offset + 1 : offset;
        int toCount = this.resolveCounter(totalArchetypes, offset + 10);
        int totalCount = this.resolveCounter(totalArchetypes, 0);
        String indicatorText = this.ts.format("ArchetypeManagement.ItemCountIndicatorText", new Object[]{fromCount, toCount, totalCount});
        this.view.setPageIndicator(indicatorText);
        this.totalPages = (int)Math.ceil((float)totalArchetypes / 10.0f);
        String totalText = this.ts.format("ArchetypeManagement.OfN", new Object[]{Math.max(this.totalPages, 1)});
        this.view.setTotalPages(totalText);
        this.view.setCurrentPage(this.currentPage);
        this.checkPaginationButtons();
    }

    private void checkPaginationButtons() {
        boolean isPreviousButtonEnabled = this.currentPage > 1;
        boolean isNextButtonEnabled = this.currentPage < this.totalPages;
        this.view.enablePreviousButton(isPreviousButtonEnabled);
        this.view.enableNextButton(isNextButtonEnabled);
        this.view.enableFirstButton(isPreviousButtonEnabled);
        this.view.enableLastButton(isNextButtonEnabled);
    }

    private int resolveCounter(int counter, int otherCounter) {
        if (counter < otherCounter || otherCounter == 0) {
            return counter;
        }
        return otherCounter;
    }

    ArchetypeTableConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.initConfiguration();
        }
        return this.configuration;
    }

    @Dependent
    public static class ArchetypeListPresenter
    extends ListPresenter<ArchetypeItem, ArchetypeItemPresenter> {
        @Inject
        public ArchetypeListPresenter(ManagedInstance<ArchetypeItemPresenter> itemPresenters) {
            super(itemPresenters);
        }
    }

    public static interface View
    extends UberElemental<AbstractArchetypeTablePresenter> {
        public void showAddAction(boolean var1);

        public void showIncludeHeader(boolean var1);

        public void showStatusHeader(boolean var1);

        public Element getTableBody();

        public void enablePreviousButton(boolean var1);

        public void enableNextButton(boolean var1);

        public void enableFirstButton(boolean var1);

        public void enableLastButton(boolean var1);

        public void setCurrentPage(int var1);

        public void setTotalPages(String var1);

        public void setPageIndicator(String var1);

        public void setSelectionCounter(String var1);

        public void showSelectionCounter(boolean var1);

        public void showNoResults(boolean var1);

        public void showPagination(boolean var1);

        public void showEmpty(boolean var1);

        public void showToolbar(boolean var1);

        public void show(boolean var1);
    }
}

