/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.adapter;

import org.kie.workbench.common.stunner.core.util.HashUtil;

public class DefinitionId {
    public static final String DYNAMIC_ID_DELIMITER = ".";
    private final String id;
    private final int dynamicIdStartIndex;

    public static DefinitionId build(String id) {
        return DefinitionId.build(id, -1);
    }

    public static DefinitionId build(String type, String id) {
        String value = DefinitionId.generateId(type, id);
        return DefinitionId.build(value, type.length());
    }

    public static DefinitionId build(String id, int dynamicIdStartIndex) {
        return new DefinitionId(id, dynamicIdStartIndex);
    }

    public static String generateId(String type, String id) {
        return type + DYNAMIC_ID_DELIMITER + id;
    }

    public DefinitionId(String id, int dynamicIdStartIndex) {
        this.id = id;
        this.dynamicIdStartIndex = dynamicIdStartIndex;
    }

    public String value() {
        return this.id;
    }

    public boolean isDynamic() {
        return this.dynamicIdStartIndex >= 0;
    }

    public String type() {
        return this.isDynamic() ? this.id.substring(0, this.dynamicIdStartIndex) : this.id;
    }

    public int hashCode() {
        return HashUtil.combineHashCodes(this.id.hashCode(), this.dynamicIdStartIndex);
    }

    public boolean equals(Object o) {
        if (o instanceof DefinitionId) {
            DefinitionId other = (DefinitionId)o;
            return this.id.equals(other.id) && this.dynamicIdStartIndex == other.dynamicIdStartIndex;
        }
        return false;
    }
}

