/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.batch;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.batch.CronJobStatus;
import io.fabric8.kubernetes.api.model.batch.CronJobStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CronJobStatusFluentImpl<A extends CronJobStatusFluent<A>>
extends BaseFluent<A>
implements CronJobStatusFluent<A> {
    private List<ObjectReferenceBuilder> active;
    private String lastScheduleTime;

    public CronJobStatusFluentImpl() {
    }

    public CronJobStatusFluentImpl(CronJobStatus instance) {
        this.withActive(instance.getActive());
        this.withLastScheduleTime(instance.getLastScheduleTime());
    }

    @Override
    public A addToActive(int index, ObjectReference item) {
        if (this.active == null) {
            this.active = new ArrayList<ObjectReferenceBuilder>();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        this._visitables.get("active").add(index >= 0 ? index : this._visitables.get("active").size(), builder);
        this.active.add(index >= 0 ? index : this.active.size(), builder);
        return (A)this;
    }

    @Override
    public A setToActive(int index, ObjectReference item) {
        if (this.active == null) {
            this.active = new ArrayList<ObjectReferenceBuilder>();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get("active").size()) {
            this._visitables.get("active").add(builder);
        } else {
            this._visitables.get("active").set(index, builder);
        }
        if (index < 0 || index >= this.active.size()) {
            this.active.add(builder);
        } else {
            this.active.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToActive(ObjectReference ... items) {
        if (this.active == null) {
            this.active = new ArrayList<ObjectReferenceBuilder>();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("active").add(builder);
            this.active.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToActive(Collection<ObjectReference> items) {
        if (this.active == null) {
            this.active = new ArrayList<ObjectReferenceBuilder>();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("active").add(builder);
            this.active.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromActive(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("active").remove(builder);
            if (this.active == null) continue;
            this.active.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromActive(Collection<ObjectReference> items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("active").remove(builder);
            if (this.active == null) continue;
            this.active.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ObjectReference> getActive() {
        return CronJobStatusFluentImpl.build(this.active);
    }

    @Override
    public List<ObjectReference> buildActive() {
        return CronJobStatusFluentImpl.build(this.active);
    }

    @Override
    public ObjectReference buildActive(int index) {
        return this.active.get(index).build();
    }

    @Override
    public ObjectReference buildFirstActive() {
        return this.active.get(0).build();
    }

    @Override
    public ObjectReference buildLastActive() {
        return this.active.get(this.active.size() - 1).build();
    }

    @Override
    public ObjectReference buildMatchingActive(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.active) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingActive(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.active) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withActive(List<ObjectReference> active) {
        if (this.active != null) {
            this._visitables.get("active").removeAll(this.active);
        }
        if (active != null) {
            this.active = new ArrayList<ObjectReferenceBuilder>();
            for (ObjectReference item : active) {
                this.addToActive(item);
            }
        } else {
            this.active = new ArrayList<ObjectReferenceBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withActive(ObjectReference ... active) {
        if (this.active != null) {
            this.active.clear();
        }
        if (active != null) {
            for (ObjectReference item : active) {
                this.addToActive(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> addNewActive() {
        return new ActiveNestedImpl();
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> addNewActiveLike(ObjectReference item) {
        return new ActiveNestedImpl(-1, item);
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> setNewActiveLike(int index, ObjectReference item) {
        return new ActiveNestedImpl(index, item);
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> editActive(int index) {
        if (this.active.size() <= index) {
            throw new RuntimeException("Can't edit active. Index exceeds size.");
        }
        return this.setNewActiveLike(index, this.buildActive(index));
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> editFirstActive() {
        if (this.active.size() == 0) {
            throw new RuntimeException("Can't edit first active. The list is empty.");
        }
        return this.setNewActiveLike(0, this.buildActive(0));
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> editLastActive() {
        int index = this.active.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last active. The list is empty.");
        }
        return this.setNewActiveLike(index, this.buildActive(index));
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> editMatchingActive(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.active.size(); ++i) {
            if (!predicate.apply(this.active.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching active. No match found.");
        }
        return this.setNewActiveLike(index, this.buildActive(index));
    }

    @Override
    public String getLastScheduleTime() {
        return this.lastScheduleTime;
    }

    @Override
    public A withLastScheduleTime(String lastScheduleTime) {
        this.lastScheduleTime = lastScheduleTime;
        return (A)this;
    }

    @Override
    public Boolean hasLastScheduleTime() {
        return this.lastScheduleTime != null;
    }

    @Override
    public A withNewLastScheduleTime(String arg1) {
        return this.withLastScheduleTime(new String(arg1));
    }

    @Override
    public A withNewLastScheduleTime(StringBuilder arg1) {
        return this.withLastScheduleTime(new String(arg1));
    }

    @Override
    public A withNewLastScheduleTime(StringBuffer arg1) {
        return this.withLastScheduleTime(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CronJobStatusFluentImpl that = (CronJobStatusFluentImpl)o;
        if (this.active != null ? !this.active.equals(that.active) : that.active != null) {
            return false;
        }
        return !(this.lastScheduleTime != null ? !this.lastScheduleTime.equals(that.lastScheduleTime) : that.lastScheduleTime != null);
    }

    public class ActiveNestedImpl<N>
    extends ObjectReferenceFluentImpl<CronJobStatusFluent.ActiveNested<N>>
    implements CronJobStatusFluent.ActiveNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;
        private final int index;

        ActiveNestedImpl(int index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        ActiveNestedImpl() {
            this.index = -1;
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CronJobStatusFluentImpl.this.setToActive(this.index, this.builder.build());
        }

        @Override
        public N endActive() {
            return this.and();
        }
    }
}

