/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import org.kie.workbench.common.stunner.bpmn.BPMNDefinitionSet;
import org.kie.workbench.common.stunner.bpmn.definition.DataObject;
import org.kie.workbench.common.stunner.bpmn.validation.BPMNViolation;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.validation.DomainValidator;
import org.kie.workbench.common.stunner.core.validation.DomainViolation;
import org.kie.workbench.common.stunner.core.validation.Violation;

public abstract class BPMNDataObjectValidator
implements DomainValidator {
    private static final String ALLOWED_CHARS = "^[a-zA-Z0-9\\-\\_\\ \\+\\/\\*\\?\\'\\.]*$";
    private static final String ILLEGAL_CHARS = ".*[#:\" ]+.*";

    public String getDefinitionSetId() {
        return BindableAdapterUtils.getDefinitionSetId(BPMNDefinitionSet.class);
    }

    public void validate(Diagram diagram, Consumer<Collection<DomainViolation>> resultConsumer) {
        Iterator it = diagram.getGraph().nodes().iterator();
        HashMap<String, String> dataObjectsMap = new HashMap<String, String>();
        ArrayList<BPMNViolation> violations = new ArrayList<BPMNViolation>();
        while (it.hasNext()) {
            BPMNViolation bpmnViolation;
            Element element = (Element)it.next();
            if (!(element.getContent() instanceof View) || !(((View)element.getContent()).getDefinition() instanceof DataObject)) continue;
            DataObject dataObject = (DataObject)((View)element.getContent()).getDefinition();
            String name = dataObject.getName().getValue();
            String type = dataObject.getType().getValue().getType();
            String containedType = (String)dataObjectsMap.get(name);
            if (containedType != null && !type.equals(containedType)) {
                bpmnViolation = new BPMNViolation(this.getMessageDataObjectWithTypeSameName() + " : " + name, Violation.Type.WARNING, element.getUUID());
                violations.add(bpmnViolation);
            } else {
                dataObjectsMap.put(name, type);
            }
            if (name.matches(ILLEGAL_CHARS)) {
                bpmnViolation = new BPMNViolation(this.getMessageDataObjectWithName() + ": " + name + " " + this.getMessageDataObjectWithIllegalCharacters(), Violation.Type.WARNING, element.getUUID());
                violations.add(bpmnViolation);
            }
            if (name.matches(ALLOWED_CHARS)) continue;
            bpmnViolation = new BPMNViolation(this.getMessageDataObjectIllegalName() + " : " + name, Violation.Type.WARNING, element.getUUID());
            violations.add(bpmnViolation);
        }
        resultConsumer.accept(violations);
    }

    public abstract String getMessageDataObjectWithTypeSameName();

    public abstract String getMessageDataObjectWithName();

    public abstract String getMessageDataObjectWithIllegalCharacters();

    public abstract String getMessageDataObjectIllegalName();
}

