/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.AssociationDeclaration;

public class AssociationDeclarationTest {
    private static final String INPUT_ASSIGNMENTS_VALUE = "[din]var1->input1";
    private static final String INPUT_ASSIGNMENTS_VALUE_MISSING = "[din]var1->";
    private static final String OUTPUT_ASSIGNMENTS_VALUE = "[dout]output1->var1";
    private static final String OUTPUT_ASSIGNMENTS_VALUE_MISSING = "[dout]output1->";

    @Test(expected=IllegalArgumentException.class)
    public void testFromStringNull() {
        AssociationDeclaration.fromString(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromStringEmpty() {
        AssociationDeclaration.fromString((String)"");
    }

    @Test
    public void testFromStringInput() {
        AssociationDeclaration associationDeclaration = AssociationDeclaration.fromString((String)INPUT_ASSIGNMENTS_VALUE);
        Assert.assertEquals((Object)associationDeclaration.getSource(), (Object)"var1");
        Assert.assertEquals((Object)associationDeclaration.getTarget(), (Object)"input1");
        Assert.assertEquals((Object)associationDeclaration.getType(), (Object)AssociationDeclaration.Type.SourceTarget);
        Assert.assertEquals((Object)associationDeclaration.getDirection(), (Object)AssociationDeclaration.Direction.Input);
    }

    @Test
    public void testFromStringOutput() {
        AssociationDeclaration associationDeclaration = AssociationDeclaration.fromString((String)OUTPUT_ASSIGNMENTS_VALUE);
        Assert.assertEquals((Object)associationDeclaration.getSource(), (Object)"output1");
        Assert.assertEquals((Object)associationDeclaration.getTarget(), (Object)"var1");
        Assert.assertEquals((Object)associationDeclaration.getType(), (Object)AssociationDeclaration.Type.SourceTarget);
        Assert.assertEquals((Object)associationDeclaration.getDirection(), (Object)AssociationDeclaration.Direction.Output);
    }

    @Test
    public void testFromStringInputMissing() {
        AssociationDeclaration associationDeclaration = AssociationDeclaration.fromString((String)INPUT_ASSIGNMENTS_VALUE_MISSING);
        Assert.assertEquals((Object)associationDeclaration.getSource(), (Object)"var1");
        Assert.assertEquals((Object)associationDeclaration.getTarget(), (Object)"");
        Assert.assertEquals((Object)associationDeclaration.getType(), (Object)AssociationDeclaration.Type.SourceTarget);
        Assert.assertEquals((Object)associationDeclaration.getDirection(), (Object)AssociationDeclaration.Direction.Input);
    }

    @Test
    public void testFromStringOutputMissing() {
        AssociationDeclaration associationDeclaration = AssociationDeclaration.fromString((String)OUTPUT_ASSIGNMENTS_VALUE_MISSING);
        Assert.assertEquals((Object)associationDeclaration.getSource(), (Object)"output1");
        Assert.assertEquals((Object)associationDeclaration.getTarget(), (Object)"");
        Assert.assertEquals((Object)associationDeclaration.getType(), (Object)AssociationDeclaration.Type.SourceTarget);
        Assert.assertEquals((Object)associationDeclaration.getDirection(), (Object)AssociationDeclaration.Direction.Output);
    }

    @Test
    public void testEquals() {
        String source = "source";
        String target = "target";
        AssociationDeclaration declaration = new AssociationDeclaration(AssociationDeclaration.Direction.Input, AssociationDeclaration.Type.FromTo, source, target);
        Assert.assertFalse((boolean)declaration.equals((Object)source));
        AssociationDeclaration declaration2 = new AssociationDeclaration(AssociationDeclaration.Direction.Input, AssociationDeclaration.Type.FromTo, source, target);
        Assert.assertEquals((Object)declaration, (Object)declaration2);
        declaration2.setDirection(AssociationDeclaration.Direction.Output);
        Assert.assertFalse((boolean)declaration.equals((Object)declaration2));
        declaration2.setDirection(AssociationDeclaration.Direction.Input);
        Assert.assertEquals((Object)declaration, (Object)declaration2);
        declaration2.setType(AssociationDeclaration.Type.SourceTarget);
        Assert.assertFalse((boolean)declaration.equals((Object)declaration2));
        declaration2.setType(AssociationDeclaration.Type.FromTo);
        Assert.assertEquals((Object)declaration, (Object)declaration2);
        declaration2.setTarget(source);
        Assert.assertFalse((boolean)declaration.equals((Object)declaration2));
        declaration2.setTarget(target);
        Assert.assertEquals((Object)declaration, (Object)declaration2);
        declaration2.setSource(target);
        Assert.assertFalse((boolean)declaration.equals((Object)declaration2));
    }
}

