/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomInput;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations.AssociationType;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.FlatVariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.UserTaskPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentsInfo;

public class ReassignmentPropertyWriterTest {
    private FlatVariableScope variableScope;

    @Before
    public void before() {
        this.variableScope = new FlatVariableScope();
    }

    @Test
    public void addOneNotStartedReassignmentValue() {
        UserTaskPropertyWriter userTaskPropertyWriter = new UserTaskPropertyWriter(Factories.bpmn2.createUserTask(), (VariableScope)this.variableScope, new HashSet());
        ReassignmentsInfo reassignmentsInfo = new ReassignmentsInfo();
        reassignmentsInfo.getValue().addValue(this.getReassignmentValue(AssociationType.NOT_STARTED_REASSIGN.getName()));
        userTaskPropertyWriter.setReassignments(reassignmentsInfo);
        CustomInput notStartedNotify = (CustomInput)this.getFieldValue(UserTaskPropertyWriter.class, userTaskPropertyWriter, "notStartedReassign");
        Assert.assertEquals((Object)this.asCDATA(this.getReassignmentValue(AssociationType.NOT_STARTED_REASSIGN.getName()).toCDATAFormat()), (Object)notStartedNotify.get());
    }

    @Test
    public void addTwoNotStartedReassignmentValue() {
        UserTaskPropertyWriter userTaskPropertyWriter = new UserTaskPropertyWriter(Factories.bpmn2.createUserTask(), (VariableScope)this.variableScope, new HashSet());
        ReassignmentsInfo reassignmentsInfo = new ReassignmentsInfo();
        reassignmentsInfo.getValue().addValue(this.getReassignmentValue(AssociationType.NOT_COMPLETED_REASSIGN.getName()));
        reassignmentsInfo.getValue().addValue(this.getReassignmentValue(AssociationType.NOT_COMPLETED_REASSIGN.getName()));
        userTaskPropertyWriter.setReassignments(reassignmentsInfo);
        String cdata = this.getReassignmentValue(AssociationType.NOT_COMPLETED_REASSIGN.getName()).toCDATAFormat();
        CustomInput notStartedNotify = (CustomInput)this.getFieldValue(UserTaskPropertyWriter.class, userTaskPropertyWriter, "notCompletedReassign");
        Assert.assertEquals((Object)this.asCDATA(cdata + "^" + cdata), (Object)notStartedNotify.get());
    }

    @Test
    public void addOneNotCompletedReassignmentValue() {
        UserTaskPropertyWriter userTaskPropertyWriter = new UserTaskPropertyWriter(Factories.bpmn2.createUserTask(), (VariableScope)this.variableScope, new HashSet());
        ReassignmentsInfo reassignmentsInfo = new ReassignmentsInfo();
        reassignmentsInfo.getValue().addValue(this.getReassignmentValue(AssociationType.NOT_COMPLETED_REASSIGN.getName()));
        userTaskPropertyWriter.setReassignments(reassignmentsInfo);
        CustomInput notStartedNotify = (CustomInput)this.getFieldValue(UserTaskPropertyWriter.class, userTaskPropertyWriter, "notCompletedReassign");
        Assert.assertEquals((Object)this.asCDATA(this.getReassignmentValue(AssociationType.NOT_COMPLETED_REASSIGN.getName()).toCDATAFormat()), (Object)notStartedNotify.get());
    }

    @Test
    public void addTwoNotCompletedReassignmentValue() {
        UserTaskPropertyWriter userTaskPropertyWriter = new UserTaskPropertyWriter(Factories.bpmn2.createUserTask(), (VariableScope)this.variableScope, new HashSet());
        ReassignmentsInfo reassignmentsInfo = new ReassignmentsInfo();
        reassignmentsInfo.getValue().addValue(this.getReassignmentValue(AssociationType.NOT_COMPLETED_REASSIGN.getName()));
        reassignmentsInfo.getValue().addValue(this.getReassignmentValue(AssociationType.NOT_COMPLETED_REASSIGN.getName()));
        userTaskPropertyWriter.setReassignments(reassignmentsInfo);
        String cdata = this.getReassignmentValue(AssociationType.NOT_COMPLETED_REASSIGN.getName()).toCDATAFormat();
        CustomInput notStartedNotify = (CustomInput)this.getFieldValue(UserTaskPropertyWriter.class, userTaskPropertyWriter, "notCompletedReassign");
        Assert.assertEquals((Object)this.asCDATA(cdata + "^" + cdata), (Object)notStartedNotify.get());
    }

    protected <T> T getFieldValue(Class parent, Object instance, String fieldName) {
        Field inputField = FieldUtils.getField((Class)parent, (String)fieldName, (boolean)true);
        try {
            return (T)inputField.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    private String asCDATA(String value) {
        return "<![CDATA[" + value + "]]>";
    }

    private ReassignmentValue getReassignmentValue(String type) {
        ArrayList<String> users = new ArrayList<String>();
        users.add("AAA");
        users.add("BBB");
        ArrayList groups = new ArrayList();
        users.add("G1");
        users.add("G2");
        ReassignmentValue value = new ReassignmentValue();
        value.setType(type);
        value.setUsers(users);
        value.setGroups(groups);
        value.setDuration("1d");
        return value;
    }
}

