/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import bpsim.ElementParameters;
import bpsim.NormalDistributionType;
import bpsim.Parameter;
import bpsim.ParameterValue;
import bpsim.PoissonDistributionType;
import bpsim.TimeParameters;
import bpsim.UniformDistributionType;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.LinkEventDefinition;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.emf.common.util.EList;
import org.jboss.drools.DroolsPackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TestUtils;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.BoundaryEventPropertyReaderTest;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.EventPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.bpmn.definition.property.common.ConditionExpression;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.TimerSettingsValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationAttributeSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class BaseEventPropertyReaderTest {
    protected static final double RESOLUTION_FACTOR = 1234.0;
    protected static final float X = 1.0f;
    protected static final float Y = 2.0f;
    protected static final String SIGNAL_REF_ID = "SIGNAL_REF_ID";
    protected static final String SIGNAL_NAME = "SIGNAL_NAME";
    protected static final String SCOPE_ELEMENT_NAME = "customScope";
    protected static final String SCOPE = "SCOPE";
    protected static final String LINK_REF_ID = "LINK_REF_ID";
    protected static final String SLADUEDATE_ELEMENT_NAME = "customSLADueDate";
    protected static final String SLADUEDATE = "12/25/1983";
    protected static final String TIME_CYCLE_LANGUAGE = "TIME_CYCLE_LANGUAGE";
    protected static final String TIME_CYCLE = "TIME_CYCLE";
    protected static final String TIME_DATE = "TIME_DATE";
    protected static final String TIME_DURATION = "TIME_DURATION";
    protected static final double MIN = 1.0;
    protected static final double MAX = 2.0;
    protected static final double MEAN = 3.0;
    protected static final double TIME_UNIT = 4.0;
    protected static final double STANDARD_DEVIATION = 5.0;
    protected static final String SCRIPT = "SCRIPT";
    @Mock
    protected DefinitionResolver definitionResolver;
    @Mock
    protected BPMNDiagram diagram;
    protected EventPropertyReader propertyReader;

    protected abstract EventPropertyReader newPropertyReader();

    protected abstract void setSignalEventDefinitionOnCurrentMock(SignalEventDefinition var1);

    protected abstract void setLinkEventDefinitionOnCurrentMock(EventDefinition var1);

    protected abstract Event getCurrentEventMock();

    @Before
    public void setUp() {
        Mockito.when((Object)this.definitionResolver.getResolutionFactor()).thenReturn((Object)1234.0);
        this.propertyReader = this.newPropertyReader();
    }

    @Test
    public void testGetSignalRef() {
        SignalEventDefinition eventDefinition = (SignalEventDefinition)Mockito.mock(SignalEventDefinition.class);
        Mockito.when((Object)eventDefinition.getSignalRef()).thenReturn((Object)SIGNAL_REF_ID);
        this.setSignalEventDefinitionOnCurrentMock(eventDefinition);
        Mockito.when((Object)this.definitionResolver.resolveSignalName(SIGNAL_REF_ID)).thenReturn((Object)SIGNAL_NAME);
        Assert.assertEquals((Object)SIGNAL_NAME, (Object)this.propertyReader.getSignalRef());
    }

    @Test
    public void testGetLinkRef() {
        if (this instanceof BoundaryEventPropertyReaderTest) {
            return;
        }
        Assert.assertEquals((Object)"", (Object)this.propertyReader.getLinkRef());
        LinkEventDefinition eventDefinition = (LinkEventDefinition)Mockito.mock(LinkEventDefinition.class);
        this.setLinkEventDefinitionOnCurrentMock((EventDefinition)eventDefinition);
        Mockito.when((Object)eventDefinition.getName()).thenReturn(null);
        Assert.assertEquals((Object)"", (Object)this.propertyReader.getLinkRef());
        Mockito.when((Object)eventDefinition.getName()).thenReturn((Object)LINK_REF_ID);
        Assert.assertEquals((Object)LINK_REF_ID, (Object)this.propertyReader.getLinkRef());
        EventDefinition differentType = (EventDefinition)Mockito.mock(EventDefinition.class);
        this.setLinkEventDefinitionOnCurrentMock(differentType);
        Assert.assertEquals((Object)"", (Object)this.propertyReader.getLinkRef());
    }

    @Test
    public void testGetSignalRefWithNoSignal() {
        Assert.assertEquals((Object)"", (Object)this.propertyReader.getSignalRef());
    }

    @Test
    public void testComputeBounds() {
        Bounds bounds = TestUtils.mockBounds(1.0f, 2.0f);
        org.kie.workbench.common.stunner.core.graph.content.Bounds result = this.propertyReader.computeBounds(bounds);
        TestUtils.assertBounds(1234.0, 2468.0, 1290.0, 2524.0, result);
    }

    @Test
    public void testGetSignalScope() {
        List<ExtensionAttributeValue> extensionValues = TestUtils.mockExtensionValues(DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, SCOPE_ELEMENT_NAME, SCOPE);
        Event eventMock = this.getCurrentEventMock();
        Mockito.when((Object)eventMock.getExtensionValues()).thenReturn(extensionValues);
        Assert.assertEquals((Object)SCOPE, (Object)this.propertyReader.getSignalScope());
    }

    @Test
    public void testGetTimerSettings() {
        TimerEventDefinition eventDefinition = (TimerEventDefinition)Mockito.mock(TimerEventDefinition.class);
        FormalExpression timeCycle = TestUtils.mockFormalExpression(TIME_CYCLE_LANGUAGE, TIME_CYCLE);
        FormalExpression timeDate = TestUtils.mockFormalExpression(TIME_DATE);
        FormalExpression timeDuration = TestUtils.mockFormalExpression(TIME_DURATION);
        Mockito.when((Object)eventDefinition.getTimeCycle()).thenReturn((Object)timeCycle);
        Mockito.when((Object)eventDefinition.getTimeDate()).thenReturn((Object)timeDate);
        Mockito.when((Object)eventDefinition.getTimeDuration()).thenReturn((Object)timeDuration);
        TimerSettingsValue value = EventPropertyReader.getTimerSettings((TimerEventDefinition)eventDefinition);
        Assert.assertEquals((Object)TIME_CYCLE_LANGUAGE, (Object)value.getTimeCycleLanguage());
        Assert.assertEquals((Object)TIME_CYCLE, (Object)value.getTimeCycle());
        Assert.assertEquals((Object)TIME_DATE, (Object)value.getTimeDate());
        Assert.assertEquals((Object)TIME_DURATION, (Object)value.getTimeDuration());
    }

    @Test
    public void testGetSimulationSetNormalDistribution() {
        NormalDistributionType paramValue = TestUtils.mockNormalDistributionType(3.0, 5.0);
        this.testGetSimulationSet(new SimulationAttributeSet(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(3.0), "ms", Double.valueOf(5.0), "normal"), (ParameterValue)paramValue);
    }

    @Test
    public void testGetSimulationSetUniformDistribution() {
        UniformDistributionType paramValue = TestUtils.mockUniformDistributionType(1.0, 2.0);
        this.testGetSimulationSet(new SimulationAttributeSet(Double.valueOf(1.0), Double.valueOf(2.0), Double.valueOf(0.0), "ms", Double.valueOf(0.0), "uniform"), (ParameterValue)paramValue);
    }

    @Test
    public void testGetSimulationSetPoissonDistribution() {
        PoissonDistributionType paramValue = TestUtils.mockPoissonDistributionType(3.0);
        this.testGetSimulationSet(new SimulationAttributeSet(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(3.0), "ms", Double.valueOf(0.0), "poisson"), (ParameterValue)paramValue);
    }

    private void testGetSimulationSet(SimulationAttributeSet expectedResult, ParameterValue distributionType) {
        ElementParameters parameters = (ElementParameters)Mockito.mock(ElementParameters.class);
        TimeParameters timeParams = (TimeParameters)Mockito.mock(TimeParameters.class);
        Mockito.when((Object)parameters.getTimeParameters()).thenReturn((Object)timeParams);
        Parameter processingTime = (Parameter)Mockito.mock(Parameter.class);
        Mockito.when((Object)timeParams.getProcessingTime()).thenReturn((Object)processingTime);
        EList parameterList = (EList)Mockito.mock(EList.class);
        Mockito.when((Object)processingTime.getParameterValue()).thenReturn((Object)parameterList);
        Mockito.when((Object)parameterList.get(0)).thenReturn((Object)distributionType);
        Mockito.when((Object)this.definitionResolver.resolveSimulationParameters(this.getCurrentEventMock().getId())).thenReturn(Optional.ofNullable(parameters));
        Assert.assertEquals((Object)expectedResult, (Object)this.propertyReader.getSimulationSet());
    }

    @Test
    public void testGetConditionExpression() {
        for (Scripts.LANGUAGE language : Scripts.LANGUAGE.values()) {
            this.testGetConditionExpression(new ConditionExpression(new ScriptTypeValue(language.language(), SCRIPT)), language.format(), SCRIPT);
        }
    }

    private void testGetConditionExpression(ConditionExpression expectedValue, String languageFormat, String script) {
        ConditionalEventDefinition eventDefinition = (ConditionalEventDefinition)Mockito.mock(ConditionalEventDefinition.class);
        FormalExpression expression = TestUtils.mockFormalExpression(languageFormat, script);
        Mockito.when((Object)eventDefinition.getCondition()).thenReturn((Object)expression);
        Assert.assertEquals((Object)expectedValue, (Object)EventPropertyReader.getConditionExpression((ConditionalEventDefinition)eventDefinition));
    }

    @Test
    public void testGetConditionExpressionNotConfigured() {
        ConditionalEventDefinition eventDefinition = (ConditionalEventDefinition)Mockito.mock(ConditionalEventDefinition.class);
        Assert.assertEquals((Object)new ConditionExpression(new ScriptTypeValue(Scripts.LANGUAGE.DROOLS.language(), "")), (Object)EventPropertyReader.getConditionExpression((ConditionalEventDefinition)eventDefinition));
    }

    @Test
    public void testCombineEventDefinitions() {
        EventDefinition definition1 = (EventDefinition)Mockito.mock(EventDefinition.class);
        EventDefinition definition2 = (EventDefinition)Mockito.mock(EventDefinition.class);
        EventDefinition definition3 = (EventDefinition)Mockito.mock(EventDefinition.class);
        List<EventDefinition> eventDefinitions = Arrays.asList(definition1, definition2, definition3);
        EventDefinition definitionRef1 = (EventDefinition)Mockito.mock(EventDefinition.class);
        EventDefinition definitionRef2 = (EventDefinition)Mockito.mock(EventDefinition.class);
        List<EventDefinition> eventDefinitionsRefs = Arrays.asList(definitionRef1, definitionRef2, null);
        List result = EventPropertyReader.combineEventDefinitions(eventDefinitions, eventDefinitionsRefs);
        Assert.assertEquals(eventDefinitions, (Object)result);
    }

    @Test
    public void testSLADueDate() {
        List<ExtensionAttributeValue> extensionValues = TestUtils.mockExtensionValues(DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, SLADUEDATE_ELEMENT_NAME, SLADUEDATE);
        Event eventMock = this.getCurrentEventMock();
        Mockito.when((Object)eventMock.getExtensionValues()).thenReturn(extensionValues);
        Assert.assertEquals((Object)SLADUEDATE, (Object)this.propertyReader.getSlaDueDate());
    }
}

