/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.StartEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.StartTimerEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseStartEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.InterruptingTimerEventExecutionSet;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class StartTimerEventTest
extends StartEventTest<StartTimerEvent> {
    private static final String BPMN_START_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/timerStartEvents.bpmn";
    private static final String FILLED_TOP_LEVEL_EVENT_MULTIPLE_ID = "8B1A8442-B1F7-44C7-A33C-180B9477E672";
    private static final String FILLED_TOP_LEVEL_EVENT_SPECIFIC_DATE_ID = "CA065A81-8586-429D-BCB9-6865153B006F";
    private static final String FILLED_TOP_LEVEL_EVENT_AFTER_DURATION_ID = "14D9E958-5461-4634-9C94-B51AD2DFEA72";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "D1207863-4C91-4AA6-8F0E-6BF8E598E8B4";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_MULTIPLE_ID = "3A82AF7C-E827-4E00-9D67-E91572D8D978";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_SPECIFIC_DATE_ID = "E1464EB2-DDD3-415F-8AE2-EA98FE294C24";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_AFTER_DURATION_ID = "20DDDE81-D3E0-4534-A6A5-F25B36466078";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "3958A858-7E9F-4A1C-862F-711DE3033A14";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 21;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME_MULTIPLE = "~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_DOCUMENTATION_MULTIPLE = "~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String TIMER_VALUE_MULTIPLE = "5m3s";
        String TIMER_VALUE_LANGUAGE_MULTIPLE = "cron";
        String EVENT_NAME_SPECIFIC_DATE = "~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String EVENT_DOCUMENTATION_SPECIFIC_DATE = "Why not\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\nhere\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String TIMER_VALUE_SPECIFIC_DATE = "2018-03-16T13:50:59+02:00";
        String EVENT_NAME_AFTER_DURATION = "'Some name'";
        String EVENT_DOCUMENTATION_AFTER_DURATION = "And some documentation\n\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String TIMER_VALUE_AFTER_DURATION = "PT1H17M";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 21);
        StartTimerEvent filledTopMultiple = (StartTimerEvent)this.getStartNodeById(diagram, FILLED_TOP_LEVEL_EVENT_MULTIPLE_ID);
        this.assertGeneralSet(filledTopMultiple.getGeneral(), "~`!@#$%^&*()_+=-{}|\\][:\";'?><,./", "~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./");
        this.assertTimerEventMultiple(filledTopMultiple.getExecutionSet(), "5m3s", "cron", true, SLA_DUE_DATE);
        StartTimerEvent filledTopSpecificDate = (StartTimerEvent)this.getStartNodeById(diagram, FILLED_TOP_LEVEL_EVENT_SPECIFIC_DATE_ID);
        this.assertGeneralSet(filledTopSpecificDate.getGeneral(), "~`!@#$%^&*()_+=-{}|\\][:\";'?><,./", "Why not\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\nhere\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./");
        this.assertTimerEventSpecificDate(filledTopSpecificDate.getExecutionSet(), "2018-03-16T13:50:59+02:00", true, SLA_DUE_DATE);
        StartTimerEvent filledTopAfterDuration = (StartTimerEvent)this.getStartNodeById(diagram, FILLED_TOP_LEVEL_EVENT_AFTER_DURATION_ID);
        this.assertGeneralSet(filledTopAfterDuration.getGeneral(), "'Some name'", "And some documentation\n\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./");
        this.assertTimerEventAfterDuration(filledTopAfterDuration.getExecutionSet(), "PT1H17M", true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 21);
        StartTimerEvent emptyTop = (StartTimerEvent)this.getStartNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID);
        this.assertGeneralSet(emptyTop.getGeneral(), "", "");
        this.assertTimerEventEmpty(emptyTop.getExecutionSet(), false, "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME_MULTIPLE = "~`!@#$%^&*()_+=-{}|\\][:\";'?><,./ name";
        String EVENT_DOCUMENTATION_MULTIPLE = "Some documentation for this event\n\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String TIMER_VALUE_MULTIPLE = "R3/PT8M3S";
        String TIMER_VALUE_LANGUAGE_MULTIPLE = "none";
        String EVENT_NAME_SPECIFIC_DATE = "~`!@#$%^&*()_+=-{}|\\][:\";'?><,./ hello how are you?";
        String EVENT_DOCUMENTATION_SPECIFIC_DATE = "~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\ndocumentaion";
        String TIMER_VALUE_SPECIFIC_DATE = "2018-03-16T13:50:59+01:00";
        String EVENT_NAME_AFTER_DURATION = "\"non empty name\"";
        String EVENT_DOCUMENTATION_AFTER_DURATION = "Time is here: ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./";
        String TIMER_VALUE_AFTER_DURATION = "PT1H15M";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 21);
        StartTimerEvent filledTopMultiple = (StartTimerEvent)this.getStartNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_MULTIPLE_ID);
        this.assertGeneralSet(filledTopMultiple.getGeneral(), "~`!@#$%^&*()_+=-{}|\\][:\";'?><,./ name", "Some documentation for this event\n\n~`!@#$%^&*()_+=-{}|\\][:\";'?><,./");
        this.assertTimerEventMultiple(filledTopMultiple.getExecutionSet(), "R3/PT8M3S", "none", true, SLA_DUE_DATE);
        StartTimerEvent filledTopSpecificDate = (StartTimerEvent)this.getStartNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_SPECIFIC_DATE_ID);
        this.assertGeneralSet(filledTopSpecificDate.getGeneral(), "~`!@#$%^&*()_+=-{}|\\][:\";'?><,./ hello how are you?", "~`!@#$%^&*()_+=-{}|\\][:\";'?><,./\ndocumentaion");
        this.assertTimerEventSpecificDate(filledTopSpecificDate.getExecutionSet(), "2018-03-16T13:50:59+01:00", true, SLA_DUE_DATE);
        StartTimerEvent filledTopAfterDuration = (StartTimerEvent)this.getStartNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_AFTER_DURATION_ID);
        this.assertGeneralSet(filledTopAfterDuration.getGeneral(), "\"non empty name\"", "Time is here: ~`!@#$%^&*()_+=-{}|\\][:\";'?><,./");
        this.assertTimerEventAfterDuration(filledTopAfterDuration.getExecutionSet(), "PT1H15M", true, SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 21);
        StartTimerEvent emptySubprocess = (StartTimerEvent)this.getStartNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID);
        this.assertGeneralSet(emptySubprocess.getGeneral(), "", "");
        this.assertTimerEventEmpty(emptySubprocess.getExecutionSet(), false, "");
    }

    @Override
    @Test
    public void testMarshallTopLevelEventFilledProperties() {
        this.checkEventMarshalling(FILLED_TOP_LEVEL_EVENT_MULTIPLE_ID);
        this.checkEventMarshalling(FILLED_TOP_LEVEL_EVENT_AFTER_DURATION_ID);
        this.checkEventMarshalling(FILLED_TOP_LEVEL_EVENT_SPECIFIC_DATE_ID);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelEventFilledProperties() {
        this.checkEventMarshalling(FILLED_SUBPROCESS_LEVEL_EVENT_MULTIPLE_ID);
        this.checkEventMarshalling(FILLED_SUBPROCESS_LEVEL_EVENT_AFTER_DURATION_ID);
        this.checkEventMarshalling(FILLED_SUBPROCESS_LEVEL_EVENT_SPECIFIC_DATE_ID);
    }

    @Override
    String getBpmnStartEventFilePath() {
        return BPMN_START_EVENT_FILE_PATH;
    }

    @Override
    String getFilledTopLevelEventId() {
        return null;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    Class<StartTimerEvent> getStartEventType() {
        return StartTimerEvent.class;
    }

    private void assertTimerEventMultiple(InterruptingTimerEventExecutionSet executionSet, String timerValue, String timeCycleLanguage, boolean isInterrupting, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getTimerSettings());
        Assert.assertEquals((Object)timerValue, (Object)executionSet.getTimerSettings().getValue().getTimeCycle());
        Assert.assertEquals((Object)timeCycleLanguage, (Object)executionSet.getTimerSettings().getValue().getTimeCycleLanguage());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeDuration());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeDate());
        this.assertStartEventIsInterrupting((BaseStartEventExecutionSet)executionSet, isInterrupting);
        this.assertStartEventSlaDueDate((BaseStartEventExecutionSet)executionSet, slaDueDate);
    }

    private void assertTimerEventAfterDuration(InterruptingTimerEventExecutionSet executionSet, String timerValue, boolean isInterrupting, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getTimerSettings());
        Assert.assertEquals((Object)timerValue, (Object)executionSet.getTimerSettings().getValue().getTimeDuration());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeDate());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeCycle());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeCycleLanguage());
        this.assertStartEventIsInterrupting((BaseStartEventExecutionSet)executionSet, isInterrupting);
        this.assertStartEventSlaDueDate((BaseStartEventExecutionSet)executionSet, slaDueDate);
    }

    private void assertTimerEventSpecificDate(InterruptingTimerEventExecutionSet executionSet, String dateValue, boolean isInterrupting, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getTimerSettings());
        Assert.assertEquals((Object)dateValue, (Object)executionSet.getTimerSettings().getValue().getTimeDate());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeCycle());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeDuration());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeCycleLanguage());
        this.assertStartEventIsInterrupting((BaseStartEventExecutionSet)executionSet, isInterrupting);
        this.assertStartEventSlaDueDate((BaseStartEventExecutionSet)executionSet, slaDueDate);
    }

    private void assertTimerEventEmpty(InterruptingTimerEventExecutionSet executionSet, boolean isInterrupting, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getTimerSettings());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeDate());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeCycle());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeDuration());
        Assert.assertNull((Object)executionSet.getTimerSettings().getValue().getTimeCycleLanguage());
        this.assertStartEventIsInterrupting((BaseStartEventExecutionSet)executionSet, isInterrupting);
        this.assertStartEventSlaDueDate((BaseStartEventExecutionSet)executionSet, slaDueDate);
    }
}

