/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.tasks;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.tasks.TaskTest;
import org.kie.workbench.common.stunner.bpmn.definition.NoneTask;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.EmptyTaskExecutionSet;

public class NoneTaskTest
extends TaskTest<NoneTask> {
    private static final String BPMN_TASK_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/noneTasks.bpmn";
    private static final String EMPTY_TOP_LEVEL_TASK_ID = "D9666725-31FB-4D20-8E81-579D8BA893CE";
    private static final String FILLED_TOP_LEVEL_TASK_ID = "4EE0C527-0D2E-411C-B277-1E6A60C9053B";
    private static final String EMPTY_SUBPROCESS_LEVEL_TASK_ID = "9DD93380-3FFB-4DD3-88B9-5423E29FB3CF";
    private static final String FILLED_SUBPROCESS_LEVEL_TASK_ID = "740A426C-9E13-4502-8031-FC002E6FCFA3";
    private static final String EMPTY_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID = "51C523B0-594E-4BBF-B50F-D190A3F6A567";
    private static final String FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID = "B6137593-169A-41A9-A1BD-240B54EF3F1E";
    private static final String EMPTY_ONE_INCOME_TOP_LEVEL_TASK_ID = "D7A75B7F-E37E-4960-BF0F-EC8867EC143A";
    private static final String FILLED_ONE_INCOME_TOP_LEVEL_TASK_ID = "C5F45AA4-2B5B-4BFE-8BEC-1FCCFA3A0E2A";
    private static final String EMPTY_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID = "981DEA00-9B6A-4FA1-86AB-7835D802A151";
    private static final String FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID = "344AC834-66D4-4FF9-89CF-EB90A3ECABCE";
    private static final String EMPTY_TWO_INCOMES_TOP_LEVEL_TASK_ID = "F4D41CC4-B8A4-40C5-8973-0FF278F4324A";
    private static final String FILLED_TWO_INCOMES_TOP_LEVEL_TASK_ID = "715FE636-0609-4031-96D4-7394B2B0D88D";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 36;

    @Override
    @Test
    public void testUnmarshallTopLevelTaskFilledProperties() {
        String TASK_NAME = "Task01 name ~!@#$%^&*()_+`-={}[]:\"|;'\\<>?,./";
        String TASK_DOCUMENTATION = "Task01 doc\n ~!@#$%^&*()_+`1234567890-={}[]:\"|;'\\<>?,./";
        this.assertDiagram(this.getDiagram(), 36);
        NoneTask filledTopLevelTask = (NoneTask)this.getTaskNodeById(this.getDiagram(), FILLED_TOP_LEVEL_TASK_ID, 0, false);
        this.assertGeneralSet(filledTopLevelTask.getGeneral(), "Task01 name ~!@#$%^&*()_+`-={}[]:\"|;'\\<>?,./", "Task01 doc\n ~!@#$%^&*()_+`1234567890-={}[]:\"|;'\\<>?,./");
        this.assertNoneTaskExecutionSet(filledTopLevelTask.getExecutionSet());
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyTaskProperties() {
        this.assertDiagram(this.getDiagram(), 36);
        NoneTask emptyTopLevelTask = (NoneTask)this.getTaskNodeById(this.getDiagram(), EMPTY_TOP_LEVEL_TASK_ID, 0, false);
        this.assertGeneralSet(emptyTopLevelTask.getGeneral(), "", "");
        this.assertNoneTaskExecutionSet(emptyTopLevelTask.getExecutionSet());
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskFilledProperties() {
        String TASK_NAME = "Task03 name ~!@#$%^&*()_+`-={}[]:\"|;'\\<>?,./";
        String TASK_DOCUMENTATION = "Task03 doc\n ~!@#$%^&*()_+`1234567890-={}[]:\"|;'\\<>?,./";
        this.assertDiagram(this.getDiagram(), 36);
        NoneTask filledSubprocessLevelTask = (NoneTask)this.getTaskNodeById(this.getDiagram(), FILLED_SUBPROCESS_LEVEL_TASK_ID, 0, false);
        this.assertGeneralSet(filledSubprocessLevelTask.getGeneral(), "Task03 name ~!@#$%^&*()_+`-={}[]:\"|;'\\<>?,./", "Task03 doc\n ~!@#$%^&*()_+`1234567890-={}[]:\"|;'\\<>?,./");
        this.assertNoneTaskExecutionSet(filledSubprocessLevelTask.getExecutionSet());
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 36);
        NoneTask emptySubprocessLevelTask = (NoneTask)this.getTaskNodeById(this.getDiagram(), EMPTY_SUBPROCESS_LEVEL_TASK_ID, 0, false);
        this.assertGeneralSet(emptySubprocessLevelTask.getGeneral(), "", "");
        this.assertNoneTaskExecutionSet(emptySubprocessLevelTask.getExecutionSet());
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskOneIncomeFilledProperties() {
        String TASK_NAME = "Task02 name ~!@#$%^&*()_+`-={}[]:\"|;'\\<>?,./";
        String TASK_DOCUMENTATION = "Task02 doc\n ~!@#$%^&*()_+`1234567890-={}[]:\"|;'\\<>?,./";
        this.assertDiagram(this.getDiagram(), 36);
        NoneTask filledTopLevelTask = (NoneTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_TOP_LEVEL_TASK_ID, 1, true);
        this.assertGeneralSet(filledTopLevelTask.getGeneral(), "Task02 name ~!@#$%^&*()_+`-={}[]:\"|;'\\<>?,./", "Task02 doc\n ~!@#$%^&*()_+`1234567890-={}[]:\"|;'\\<>?,./");
        this.assertNoneTaskExecutionSet(filledTopLevelTask.getExecutionSet());
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskOneIncomeEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 36);
        NoneTask emptyTopLevelTask = (NoneTask)this.getTaskNodeById(this.getDiagram(), EMPTY_ONE_INCOME_TOP_LEVEL_TASK_ID, 1, true);
        this.assertGeneralSet(emptyTopLevelTask.getGeneral(), "", "");
        this.assertNoneTaskExecutionSet(emptyTopLevelTask.getExecutionSet());
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskOneIncomeEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 36);
        NoneTask emptySubprocessLevelTask = (NoneTask)this.getTaskNodeById(this.getDiagram(), EMPTY_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID, 1, true);
        this.assertGeneralSet(emptySubprocessLevelTask.getGeneral(), "", "");
        this.assertNoneTaskExecutionSet(emptySubprocessLevelTask.getExecutionSet());
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskOneIncomeFilledProperties() {
        String TASK_NAME = "Task04 name ~!@#$%^&*()_+`-={}[]:\"|;'\\<>?,./";
        String TASK_DOCUMENTATION = "Task04 doc\n ~!@#$%^&*()_+`1234567890-={}[]:\"|;'\\<>?,./";
        this.assertDiagram(this.getDiagram(), 36);
        NoneTask filledSubprocessLevelTask = (NoneTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID, 1, true);
        this.assertGeneralSet(filledSubprocessLevelTask.getGeneral(), "Task04 name ~!@#$%^&*()_+`-={}[]:\"|;'\\<>?,./", "Task04 doc\n ~!@#$%^&*()_+`1234567890-={}[]:\"|;'\\<>?,./");
        this.assertNoneTaskExecutionSet(filledSubprocessLevelTask.getExecutionSet());
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskTwoIncomesFilledProperties() {
        String TASK_NAME = "Task05 name ~!@#$%^&*()_+`-={}[]:\"|;'\\<>?,./";
        String TASK_DOCUMENTATION = "Task05 doc\n ~!@#$%^&*()_+`1234567890-={}[]:\"|;'\\<>?,./";
        this.assertDiagram(this.getDiagram(), 36);
        NoneTask filledTopLevelTask = (NoneTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_TOP_LEVEL_TASK_ID, 2, true);
        this.assertGeneralSet(filledTopLevelTask.getGeneral(), "Task05 name ~!@#$%^&*()_+`-={}[]:\"|;'\\<>?,./", "Task05 doc\n ~!@#$%^&*()_+`1234567890-={}[]:\"|;'\\<>?,./");
        this.assertNoneTaskExecutionSet(filledTopLevelTask.getExecutionSet());
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskTwoIncomesEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 36);
        NoneTask filledTopLevelTask = (NoneTask)this.getTaskNodeById(this.getDiagram(), EMPTY_TWO_INCOMES_TOP_LEVEL_TASK_ID, 2, true);
        this.assertGeneralSet(filledTopLevelTask.getGeneral(), "", "");
        this.assertNoneTaskExecutionSet(filledTopLevelTask.getExecutionSet());
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskTwoIncomesEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 36);
        NoneTask emptySubprocessLevelTask = (NoneTask)this.getTaskNodeById(this.getDiagram(), EMPTY_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID, 2, true);
        this.assertGeneralSet(emptySubprocessLevelTask.getGeneral(), "", "");
        this.assertNoneTaskExecutionSet(emptySubprocessLevelTask.getExecutionSet());
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskTwoIncomesFilledProperties() {
        String TASK_NAME = "Task06 name ~!@#$%^&*()_+`-={}[]:\"|;'\\<>?,./";
        String TASK_DOCUMENTATION = "Task06 doc\n ~!@#$%^&*()_+`1234567890-={}[]:\"|;'\\<>?,./";
        this.assertDiagram(this.getDiagram(), 36);
        NoneTask filledSubprocessLevelTask = (NoneTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID, 2, true);
        this.assertGeneralSet(filledSubprocessLevelTask.getGeneral(), "Task06 name ~!@#$%^&*()_+`-={}[]:\"|;'\\<>?,./", "Task06 doc\n ~!@#$%^&*()_+`1234567890-={}[]:\"|;'\\<>?,./");
        this.assertNoneTaskExecutionSet(filledSubprocessLevelTask.getExecutionSet());
    }

    @Override
    String getBpmnTaskFilePath() {
        return BPMN_TASK_FILE_PATH;
    }

    @Override
    Class<NoneTask> getTaskType() {
        return NoneTask.class;
    }

    @Override
    String getFilledTopLevelTaskId() {
        return FILLED_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getEmptyTopLevelTaskId() {
        return EMPTY_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getFilledSubprocessLevelTaskId() {
        return FILLED_SUBPROCESS_LEVEL_TASK_ID;
    }

    @Override
    String getEmptySubprocessLevelTaskId() {
        return EMPTY_SUBPROCESS_LEVEL_TASK_ID;
    }

    @Override
    String getFilledTopLevelTaskOneIncomeId() {
        return FILLED_ONE_INCOME_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getEmptyTopLevelTaskOneIncomeId() {
        return EMPTY_ONE_INCOME_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getFilledSubprocessLevelTaskOneIncomeId() {
        return FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID;
    }

    @Override
    String getEmptySubprocessLevelTaskOneIncomeId() {
        return EMPTY_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID;
    }

    @Override
    String getFilledTopLevelTaskTwoIncomesId() {
        return FILLED_TWO_INCOMES_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getEmptyTopLevelTaskTwoIncomesId() {
        return EMPTY_TWO_INCOMES_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getFilledSubprocessLevelTaskTwoIncomesId() {
        return FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID;
    }

    @Override
    String getEmptySubprocessLevelTaskTwoIncomesId() {
        return EMPTY_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID;
    }

    private void assertNoneTaskExecutionSet(EmptyTaskExecutionSet executionSet) {
        Assert.assertNotNull((Object)executionSet);
    }
}

