/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumValueMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMessageTypeMetadata;

abstract class ProtoTypeMetadata {
    protected final String name;
    protected final Class<?> javaClass;
    protected final String documentation;
    protected ProtoMessageTypeMetadata outerType;

    protected ProtoTypeMetadata(String name, Class<?> javaClass, String documentation) {
        this.name = name;
        this.javaClass = javaClass;
        this.documentation = documentation;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        StringBuilder sb = new StringBuilder();
        for (ProtoMessageTypeMetadata t = this.outerType; t != null; t = t.getOuterType()) {
            sb.append(t.getName()).append('.');
        }
        sb.append(this.name);
        return sb.toString();
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public String getJavaClassName() {
        String canonicalName = this.javaClass.getCanonicalName();
        return canonicalName != null ? canonicalName : this.javaClass.getName();
    }

    public abstract boolean isEnum();

    public abstract ProtoEnumValueMetadata getEnumMemberByName(String var1);

    public final ProtoMessageTypeMetadata getOuterType() {
        return this.outerType;
    }

    protected final void setOuterType(ProtoMessageTypeMetadata outerType) {
        this.outerType = outerType;
    }

    public final boolean isTopLevel() {
        return this.outerType == null;
    }

    public void generateProto(IndentWriter iw) {
    }

    public void scanMemberAnnotations() {
    }

    protected static void appendDocumentation(IndentWriter iw, String documentation) {
        if (documentation != null) {
            iw.append("/**\n");
            for (String s : documentation.split("\\r\\n|\\n|\\r")) {
                iw.append(" * ").append(s).append('\n');
            }
            iw.append(" */\n");
        }
    }
}

