/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import com.google.common.base.Strings;
import java.util.Objects;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Property;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Ids;

public class VariableDeclaration {
    private final ItemDefinition typeDeclaration;
    private final Property typedIdentifier;
    private String identifier;
    private String type;
    private String tags;

    public VariableDeclaration(String identifier, String type) {
        this(identifier, type, "");
    }

    public VariableDeclaration(String identifier, String type, String tags) {
        this.setIdentifier(identifier);
        this.type = type;
        this.typeDeclaration = Factories.bpmn2.createItemDefinition();
        this.typeDeclaration.setId(Ids.item(this.getIdentifier()));
        this.typeDeclaration.setStructureRef(type);
        this.typedIdentifier = Factories.bpmn2.createProperty();
        this.typedIdentifier.setId(Ids.typedIdentifier("GLOBAL", this.getIdentifier()));
        this.typedIdentifier.setName(identifier);
        this.typedIdentifier.setItemSubjectRef(this.typeDeclaration);
        this.tags = tags;
    }

    public static VariableDeclaration fromString(String encoded) {
        String type;
        String[] split = encoded.split(":");
        String identifier = split[0];
        String string = type = split.length == 2 || split.length == 3 ? split[1] : "";
        if (identifier.isEmpty()) {
            throw new IllegalArgumentException("Variable identifier cannot be empty. Given: '" + encoded + "'");
        }
        String tags = "";
        if (split.length == 3) {
            tags = split[2];
        }
        return new VariableDeclaration(identifier, type, tags);
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        String safeIdentifier;
        this.identifier = safeIdentifier = identifier.replaceAll(" ", "-");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ItemDefinition getTypeDeclaration() {
        return this.typeDeclaration;
    }

    public Property getTypedIdentifier() {
        return this.typedIdentifier;
    }

    public String toString() {
        String tagsString = "";
        if (!Strings.isNullOrEmpty((String)this.tags)) {
            tagsString = ":" + this.tags;
        }
        if (this.type == null || this.type.isEmpty()) {
            return this.typedIdentifier.getName() + tagsString;
        }
        return this.typedIdentifier.getName() + ":" + this.type + tagsString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableDeclaration that = (VariableDeclaration)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.type, that.type) && Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.type, this.tags);
    }
}

