/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Documentation;
import org.eclipse.bpmn2.Interface;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.dd.dc.Bounds;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Ids;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.Scripts;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public abstract class BasePropertyWriter {
    protected final BaseElement baseElement;
    protected final VariableScope variableScope;
    protected final List<ItemDefinition> itemDefinitions = new ArrayList<ItemDefinition>();
    protected final List<RootElement> rootElements = new ArrayList<RootElement>();
    protected final List<Interface> interfaces = new ArrayList<Interface>();
    protected BPMNShape shape;

    public BasePropertyWriter(BaseElement baseElement, VariableScope variableScope) {
        this.baseElement = baseElement;
        this.variableScope = variableScope;
    }

    public String getId() {
        return this.baseElement.getId();
    }

    public void setId(String id) {
        this.baseElement.setId(id);
    }

    protected void setBounds(org.kie.workbench.common.stunner.core.graph.content.Bounds rect) {
        this.shape = Factories.di.createBPMNShape();
        this.shape.setId(Ids.bpmnShape(this.getId()));
        this.shape.setBpmnElement(this.baseElement);
        Bounds bounds = Factories.dc.createBounds();
        Bound upperLeft = rect.getUpperLeft();
        Bound lowerRight = rect.getLowerRight();
        bounds.setX(upperLeft.getX().floatValue());
        bounds.setY(upperLeft.getY().floatValue());
        bounds.setWidth(lowerRight.getX().floatValue() - upperLeft.getX().floatValue());
        bounds.setHeight(lowerRight.getY().floatValue() - upperLeft.getY().floatValue());
        this.shape.setBounds(bounds);
    }

    public void setAbsoluteBounds(Node<? extends View, ?> node) {
        this.setBounds(BasePropertyWriter.absoluteBounds(node));
    }

    public BaseElement getElement() {
        return this.baseElement;
    }

    public void setDocumentation(String value) {
        if (!StringUtils.isEmpty((String)value)) {
            Documentation documentation = Factories.bpmn2.createDocumentation();
            documentation.setText(Scripts.asCData(value));
            this.baseElement.getDocumentation().add(documentation);
        }
    }

    public BPMNShape getShape() {
        return this.shape;
    }

    public BPMNEdge getEdge() {
        return null;
    }

    public void setSource(BasePropertyWriter source) {
    }

    public void setTarget(BasePropertyWriter target) {
    }

    public void addChild(BasePropertyWriter child) {
    }

    public void setParent(BasePropertyWriter parent) {
        parent.addChild(this);
    }

    protected void addItemDefinition(ItemDefinition itemDefinition) {
        this.itemDefinitions.add(itemDefinition);
    }

    protected void addInterfaceDefinition(Interface iface) {
        this.interfaces.add(iface);
    }

    protected void addRootElement(RootElement rootElement) {
        this.rootElements.add(rootElement);
    }

    public List<ItemDefinition> getItemDefinitions() {
        return this.itemDefinitions;
    }

    public List<RootElement> getRootElements() {
        return this.rootElements;
    }

    public List<Interface> getInterfaces() {
        return this.interfaces;
    }

    public static org.kie.workbench.common.stunner.core.graph.content.Bounds absoluteBounds(Node<? extends View, ?> node) {
        Point2D point2D = GraphUtils.getComputedPosition(node);
        org.kie.workbench.common.stunner.core.graph.content.Bounds bounds = ((View)node.getContent()).getBounds();
        return org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)point2D.getX(), (double)point2D.getY(), (double)(point2D.getX() + bounds.getWidth()), (double)(point2D.getY() + bounds.getHeight()));
    }
}

