/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.SubProcess;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.ResultComposer;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BaseConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes.ProcessConverterDelegate;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.AdHocSubProcessPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.MultipleInstanceSubProcessPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.SubProcessPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.BaseAdHocSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EmbeddedSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EventSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.MultipleInstanceSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Documentation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.SLADueDate;
import org.kie.workbench.common.stunner.bpmn.definition.property.subProcess.execution.EmbeddedSubprocessExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.subProcess.execution.EventSubprocessExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BaseAdHocSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.IsAsync;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.IsMultipleInstance;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceCollectionInput;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceCollectionOutput;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceCompletionCondition;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceDataInput;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceDataOutput;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceExecutionMode;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnEntryAction;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnExitAction;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.BaseProcessData;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessVariables;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public abstract class BaseSubProcessConverter<A extends BaseAdHocSubprocess<P, S>, P extends BaseProcessData, S extends BaseAdHocSubprocessTaskExecutionSet> {
    final ProcessConverterDelegate delegate;

    public BaseSubProcessConverter(TypedFactoryManager typedFactoryManager, PropertyReaderFactory propertyReaderFactory, DefinitionResolver definitionResolver, BaseConverterFactory converterFactory) {
        this.delegate = new ProcessConverterDelegate(typedFactoryManager, propertyReaderFactory, definitionResolver, converterFactory);
    }

    public Result<BpmnNode> convertSubProcess(SubProcess subProcess) {
        BpmnNode subProcessRoot = subProcess instanceof AdHocSubProcess ? this.convertAdHocSubProcess((AdHocSubProcess)subProcess) : (subProcess.getLoopCharacteristics() != null ? this.convertMultInstanceSubprocessNode(subProcess) : (subProcess.isTriggeredByEvent() ? this.convertEventSubprocessNode(subProcess) : this.convertEmbeddedSubprocessNode(subProcess)));
        Result<Map<String, BpmnNode>> nodesResult = this.delegate.convertChildNodes(subProcessRoot, subProcess.getFlowElements(), subProcess.getLaneSets());
        Map<String, BpmnNode> nodes = nodesResult.value();
        Result<Boolean> edgesResult = this.delegate.convertEdges(subProcessRoot, Stream.concat(subProcess.getFlowElements().stream(), subProcess.getArtifacts().stream()).collect(Collectors.toList()), nodes);
        return ResultComposer.compose(subProcessRoot, nodesResult, edgesResult);
    }

    private BpmnNode convertMultInstanceSubprocessNode(SubProcess subProcess) {
        Node node = this.delegate.factoryManager.newNode(subProcess.getId(), MultipleInstanceSubprocess.class);
        MultipleInstanceSubprocess definition = (MultipleInstanceSubprocess)((View)node.getContent()).getDefinition();
        MultipleInstanceSubProcessPropertyReader p = this.delegate.propertyReaderFactory.ofMultipleInstance(subProcess);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setExecutionSet(new MultipleInstanceSubprocessTaskExecutionSet(new MultipleInstanceExecutionMode(p.isSequential()), new MultipleInstanceCollectionInput(p.getCollectionInput()), new MultipleInstanceCollectionOutput(p.getCollectionOutput()), new MultipleInstanceDataInput(p.getDataInput()), new MultipleInstanceDataOutput(p.getDataOutput()), new MultipleInstanceCompletionCondition(p.getCompletionCondition()), new OnEntryAction(p.getOnEntryAction()), new OnExitAction(p.getOnExitAction()), new IsMultipleInstance(Boolean.valueOf(true)), new IsAsync(Boolean.valueOf(p.isAsync())), new SLADueDate(p.getSlaDueDate())));
        definition.setProcessData(new ProcessData(new ProcessVariables(p.getProcessVariables())));
        definition.setSimulationSet(p.getSimulationSet());
        definition.setDimensionsSet(p.getRectangleDimensionsSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        ((View)node.getContent()).setBounds(p.getBounds());
        return BpmnNode.of(node, p);
    }

    private BpmnNode convertAdHocSubProcess(AdHocSubProcess subProcess) {
        Node<View<A>, Edge> node = this.createNode(subProcess.getId());
        BaseAdHocSubprocess definition = (BaseAdHocSubprocess)((View)node.getContent()).getDefinition();
        AdHocSubProcessPropertyReader p = this.delegate.propertyReaderFactory.of(subProcess);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setProcessData(this.createProcessData(p.getProcessVariables()));
        definition.setExecutionSet(this.createAdHocSubprocessTaskExecutionSet(p));
        definition.setSimulationSet(p.getSimulationSet());
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getRectangleDimensionsSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(node, p);
    }

    private BpmnNode convertEmbeddedSubprocessNode(SubProcess subProcess) {
        Node node = this.delegate.factoryManager.newNode(subProcess.getId(), EmbeddedSubprocess.class);
        EmbeddedSubprocess definition = (EmbeddedSubprocess)((View)node.getContent()).getDefinition();
        SubProcessPropertyReader p = this.delegate.propertyReaderFactory.of(subProcess);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setExecutionSet(new EmbeddedSubprocessExecutionSet(new OnEntryAction(p.getOnEntryAction()), new OnExitAction(p.getOnExitAction()), new IsAsync(Boolean.valueOf(p.isAsync())), new SLADueDate(p.getSlaDueDate())));
        definition.setProcessData(new ProcessData(new ProcessVariables(p.getProcessVariables())));
        definition.setSimulationSet(p.getSimulationSet());
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getRectangleDimensionsSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return BpmnNode.of(node, p);
    }

    private BpmnNode convertEventSubprocessNode(SubProcess subProcess) {
        Node node = this.delegate.factoryManager.newNode(subProcess.getId(), EventSubprocess.class);
        EventSubprocess definition = (EventSubprocess)((View)node.getContent()).getDefinition();
        SubProcessPropertyReader p = this.delegate.propertyReaderFactory.of(subProcess);
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        definition.setExecutionSet(new EventSubprocessExecutionSet(new IsAsync(Boolean.valueOf(p.isAsync())), new SLADueDate(p.getSlaDueDate())));
        definition.setProcessData(new ProcessData(new ProcessVariables(p.getProcessVariables())));
        definition.setSimulationSet(p.getSimulationSet());
        definition.setDimensionsSet(p.getRectangleDimensionsSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        ((View)node.getContent()).setBounds(p.getBounds());
        return BpmnNode.of(node, p);
    }

    protected abstract Node<View<A>, Edge> createNode(String var1);

    protected abstract P createProcessData(String var1);

    protected abstract S createAdHocSubprocessTaskExecutionSet(AdHocSubProcessPropertyReader var1);
}

