/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Documentation;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.dd.dc.Bounds;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BackgroundSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BgColor;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BorderColor;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BorderSize;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.CircleDimensionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.Radius;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontBorderColor;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontBorderSize;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontColor;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontFamily;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSize;

public class BasePropertyReader
implements PropertyReader {
    protected final BaseElement element;
    protected final BPMNShape shape;
    protected final BPMNDiagram diagram;
    protected final double resolutionFactor;

    public BasePropertyReader(BaseElement element, BPMNDiagram diagram, BPMNShape shape, double resolutionFactor) {
        this.element = element;
        this.diagram = diagram;
        this.shape = shape;
        this.resolutionFactor = resolutionFactor;
    }

    @Override
    public String getDocumentation() {
        return this.element.getDocumentation().stream().findFirst().map(Documentation::getText).orElse("");
    }

    @Override
    public String getDescription() {
        return (String)CustomElement.description.of(this.element).get();
    }

    @Override
    public FontSet getFontSet() {
        FontFamily fontFamily = new FontFamily();
        FontColor fontColor = new FontColor(this.optionalAttribute("fontcolor").orElse(this.colorsDefaultFont()));
        FontSize fontSize = new FontSize((Double)this.optionalAttribute("fontsize").map(Double::parseDouble).orElse(null));
        FontBorderSize fontBorderSize = new FontBorderSize();
        FontBorderColor fontBorderColor = new FontBorderColor();
        return new FontSet(fontFamily, fontColor, fontSize, fontBorderSize, fontBorderColor);
    }

    @Override
    public BackgroundSet getBackgroundSet() {
        return new BackgroundSet(new BgColor(this.optionalAttribute("bgcolor").orElse(this.colorsDefaultBg())), new BorderColor(this.optionalAttribute("bordercolor").orElse(this.colorsDefaultBr())), new BorderSize());
    }

    protected String colorsDefaultBg() {
        return null;
    }

    protected String colorsDefaultBr() {
        return null;
    }

    protected String colorsDefaultFont() {
        return null;
    }

    protected Optional<String> optionalAttribute(String ... attributeIds) {
        if (this.element.getAnyAttribute().isEmpty()) {
            return Optional.empty();
        }
        List<String> attributes = Arrays.asList(attributeIds);
        return this.element.getAnyAttribute().stream().filter(e -> attributes.contains(e.getEStructuralFeature().getName())).map(e -> e.getValue().toString()).findFirst();
    }

    @Override
    public org.kie.workbench.common.stunner.core.graph.content.Bounds getBounds() {
        if (this.shape == null) {
            return org.kie.workbench.common.stunner.core.graph.content.Bounds.create();
        }
        return this.computeBounds(this.shape.getBounds());
    }

    protected org.kie.workbench.common.stunner.core.graph.content.Bounds computeBounds(Bounds bounds) {
        double x = (double)bounds.getX() * this.resolutionFactor;
        double y = (double)bounds.getY() * this.resolutionFactor;
        double width = (double)bounds.getWidth() * this.resolutionFactor;
        double height = (double)bounds.getHeight() * this.resolutionFactor;
        return org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)x, (double)y, (double)(x + width), (double)(y + height));
    }

    @Override
    public CircleDimensionSet getCircleDimensionSet() {
        if (this.shape == null) {
            return new CircleDimensionSet();
        }
        return new CircleDimensionSet(new Radius(Double.valueOf((double)this.shape.getBounds().getWidth() * this.resolutionFactor / 2.0)));
    }

    @Override
    public RectangleDimensionsSet getRectangleDimensionsSet() {
        if (this.shape == null) {
            return new RectangleDimensionsSet();
        }
        Bounds bounds = this.shape.getBounds();
        return new RectangleDimensionsSet(Double.valueOf((double)bounds.getWidth() * this.resolutionFactor), Double.valueOf((double)bounds.getHeight() * this.resolutionFactor));
    }

    @Override
    public boolean isExpanded() {
        return this.shape.isIsExpanded();
    }

    @Override
    public BaseElement getElement() {
        return this.element;
    }

    @Override
    public BPMNShape getShape() {
        return this.shape;
    }
}

