/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.workitem;

import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.workbench.common.stunner.core.backend.util.URLUtils;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class WorkItemDefinitionResources {
    private static final Logger LOG = LoggerFactory.getLogger((String)WorkItemDefinitionResources.class.getName());
    public static final String EXTENSION_WID = ".wid";
    public static final String PATH_GLOBAL = "global/";
    public static final String PATH_RESOURCES = "src/main/resources";
    private final IOService ioService;

    protected WorkItemDefinitionResources() {
        this(null);
    }

    @Inject
    public WorkItemDefinitionResources(@Named(value="ioStrategy") IOService ioService) {
        this.ioService = ioService;
    }

    public Collection<org.uberfire.backend.vfs.Path> resolveResources(Metadata metadata) {
        return this.resolveResources(this.resolveResourcePath(metadata), this.resolveGlobalPath(metadata), this.resolveResourcesPath(metadata), p -> p);
    }

    public Optional<org.uberfire.backend.vfs.Path> resolveResource(Metadata metadata, org.uberfire.backend.vfs.Path resource, String fileName) {
        Collection<org.uberfire.backend.vfs.Path> paths = this.resolveResources(this.ioService.get(resource.toURI(), new String[0]), this.resolveGlobalPath(metadata), this.resolveResourcesPath(metadata), p -> p.resolve(fileName));
        return paths.isEmpty() ? Optional.empty() : Optional.of(paths.iterator().next());
    }

    public Collection<org.uberfire.backend.vfs.Path> resolveResources(Path resource, Path global, Path resources, Function<Path, Path> mapper) {
        Path resourcePath = Files.isDirectory((Path)resource, (LinkOption[])new LinkOption[0]) ? resource : resource.getParent();
        return Stream.of(resourcePath, global, resources).map(mapper).filter(arg_0 -> ((IOService)this.ioService).exists(arg_0)).map(Paths::convert).collect(Collectors.toList());
    }

    public String generateIconDataURI(Metadata metadata, org.uberfire.backend.vfs.Path wid, String icon) {
        return this.resolveResource(metadata, wid, icon).map(this::generateDataURI).orElse(null);
    }

    private String generateDataURI(org.uberfire.backend.vfs.Path iconPath) {
        try {
            return URLUtils.buildDataURIFromStream((String)iconPath.getFileName(), (InputStream)this.ioService.newInputStream(Paths.convert((org.uberfire.backend.vfs.Path)iconPath), new OpenOption[0]));
        }
        catch (Exception e) {
            LOG.error("Error generating icon data uri for path [" + iconPath + "]", (Throwable)e);
            return null;
        }
    }

    public Path resolveResourcePath(Metadata metadata) {
        return this.ioService.get(metadata.getPath().toURI(), new String[0]);
    }

    protected Path resolveGlobalPathByRoot(org.uberfire.backend.vfs.Path path) {
        return this.ioService.get(path.toURI(), new String[0]).resolve(PATH_GLOBAL);
    }

    public Path resolveGlobalPath(Metadata metadata) {
        return this.resolveGlobalPathByRoot(metadata.getRoot());
    }

    public Path resolveResourcesPath(Metadata metadata) {
        return this.ioService.get(metadata.getRoot().toURI(), new String[0]).resolve(PATH_RESOURCES);
    }

    public static boolean isWorkItemDefinition(org.uberfire.backend.vfs.Path path) {
        return WorkItemDefinitionResources.isWorkItemDefinition(path.getFileName());
    }

    public static boolean isWorkItemDefinition(String fileName) {
        return fileName.toLowerCase().endsWith(EXTENSION_WID);
    }

    public static boolean isHidden(org.uberfire.backend.vfs.Path path) {
        return WorkItemDefinitionResources.isHidden(path.getFileName());
    }

    public static boolean isHidden(String fileName) {
        return fileName.startsWith(".");
    }

    protected IOService getIoService() {
        return this.ioService;
    }
}

