/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import org.drools.workbench.models.commons.backend.rule.RuleModelIActionPersistenceExtension;
import org.drools.workbench.models.commons.backend.rule.exception.RuleModelDRLPersistenceException;
import org.drools.workbench.models.datamodel.rule.PluggableIAction;
import org.optaplanner.workbench.models.datamodel.rule.ActionBendableSoftConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionSoftConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.PersistenceExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class SoftConstraintMatchPersistenceExtension
implements RuleModelIActionPersistenceExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoftConstraintMatchPersistenceExtension.class);
    private static final Pattern CONSTRAINT_MATCH_PATTERN = Pattern.compile("scoreHolder\\.addSoftConstraintMatch\\(\\s*kcontext\\s*,.+\\);");

    public boolean accept(String iActionString) {
        return CONSTRAINT_MATCH_PATTERN.matcher(iActionString).matches();
    }

    public PluggableIAction unmarshal(String iActionString) throws RuleModelDRLPersistenceException {
        String[] parameters = PersistenceExtensionUtils.unwrapParenthesis(iActionString).split("\\s*,\\s*");
        if ("kcontext".equals(parameters[0])) {
            if (parameters.length == 2) {
                return new ActionSoftConstraintMatch(PersistenceExtensionUtils.extractConstraintMatchValue(parameters[1]));
            }
            if (parameters.length == 3) {
                try {
                    int bendableScoreLevel = Integer.parseInt(parameters[1]);
                    return new ActionBendableSoftConstraintMatch(bendableScoreLevel, PersistenceExtensionUtils.extractConstraintMatchValue(parameters[2]));
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Could not parse bendable score level parameter " + parameters[1] + " as an Integer");
                }
            }
        }
        throw new RuleModelDRLPersistenceException("Could not unmarshal action string " + iActionString);
    }
}

