/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion;

import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.drools.workbench.models.datamodel.rule.Attribute;
import org.drools.workbench.models.datamodel.workitems.PortableParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.BRLColumnSubHeaderProvider;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.XLSColumnUtilities;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.ColumnContext;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.NotificationReporter;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.Skipper;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;

public class SubHeaderBuilder {
    public static final String ACTION = "ACTION";
    public static final String METADATA = "METADATA";
    public static final String CONDITION = "CONDITION";
    private static final int COLUMN_TYPE_ROW = 5;
    private static final int FIELD_ROW = 7;
    private static final int HEADER_TITLE_ROW = 8;
    private final GuidedDecisionTable52 dtable;
    private final XLSColumnUtilities columnUtilities;
    private final Row headerRow;
    private final Row fieldRow;
    private final Row headerTitleRow;
    private int targetColumnIndex = 0;
    private final BRLColumnSubHeaderProvider brlColumnSubHeaderProvider;
    private final ColumnContext columnContext;
    private int sourceColumnIndex = 0;

    public ColumnContext getColumnContext() {
        return this.columnContext;
    }

    public Row getFieldRow() {
        return this.fieldRow;
    }

    public int getTargetColumnIndex() {
        return this.targetColumnIndex;
    }

    public SubHeaderBuilder(Sheet sheet, GuidedDecisionTable52 dtable, PackageDataModelOracle dmo, ColumnContext columnContext) {
        PortablePreconditions.checkNotNull((String)"sheet", (Object)sheet);
        this.dtable = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"dtable", (Object)dtable);
        this.columnContext = (ColumnContext)PortablePreconditions.checkNotNull((String)"brlColumnIndex", (Object)columnContext);
        this.brlColumnSubHeaderProvider = new BRLColumnSubHeaderProvider(this, columnContext);
        this.columnUtilities = new XLSColumnUtilities(dtable, (PackageDataModelOracle)PortablePreconditions.checkNotNull((String)"dmo", (Object)dmo), false);
        this.headerRow = sheet.createRow(5);
        this.fieldRow = sheet.createRow(7);
        this.headerTitleRow = sheet.createRow(8);
    }

    public void build(NotificationReporter notificationReporter) {
        List expandedColumns = this.dtable.getExpandedColumns();
        while (this.sourceColumnIndex < expandedColumns.size()) {
            BaseColumn baseColumn = (BaseColumn)expandedColumns.get(this.sourceColumnIndex);
            if (!Skipper.shouldSkip(notificationReporter, baseColumn)) {
                BRLConditionColumn brlColumn;
                if (baseColumn instanceof AttributeCol52) {
                    this.addAttribute((AttributeCol52)baseColumn);
                } else if (baseColumn instanceof MetadataCol52) {
                    this.addMetadata((MetadataCol52)baseColumn);
                } else if (baseColumn instanceof BRLConditionVariableColumn) {
                    brlColumn = this.dtable.getBRLColumn((BRLConditionVariableColumn)baseColumn);
                    this.addBRLConditionColumn(brlColumn);
                    this.sourceColumnIndex = this.sourceColumnIndex + brlColumn.getChildColumns().size() - 1;
                } else if (baseColumn instanceof BRLActionVariableColumn) {
                    brlColumn = this.dtable.getBRLColumn((BRLActionVariableColumn)baseColumn);
                    this.addBRLActionColumn((BRLActionColumn)brlColumn);
                    this.sourceColumnIndex = this.sourceColumnIndex + brlColumn.getChildColumns().size() - 1;
                } else if (baseColumn instanceof ConditionCol52) {
                    this.addCondition((ConditionCol52)baseColumn);
                } else if (baseColumn instanceof ActionCol52) {
                    this.addAction((ActionCol52)baseColumn);
                } else if (!(baseColumn instanceof DescriptionCol52)) {
                    throw new IllegalArgumentException("TODO REMOTE THIS");
                }
                this.incrementTargetIndex();
            }
            ++this.sourceColumnIndex;
        }
    }

    public void incrementTargetIndex() {
        ++this.targetColumnIndex;
    }

    private void addBRLConditionColumn(BRLConditionColumn brlColumn) {
        this.brlColumnSubHeaderProvider.getBRLColumnSubHeaderBuilder(this.dtable, brlColumn);
    }

    private void addBRLActionColumn(BRLActionColumn brlColumn) {
        this.brlColumnSubHeaderProvider.getBRLColumnSubHeaderBuilder(this.dtable, brlColumn);
    }

    public void addAction(ActionCol52 baseColumn) {
        if (baseColumn instanceof ActionWorkItemSetFieldCol52) {
            this.addWorkItemSetField((ActionWorkItemSetFieldCol52)baseColumn);
        } else if (baseColumn instanceof ActionSetFieldCol52) {
            this.addSetField((ActionSetFieldCol52)baseColumn);
        } else if (baseColumn instanceof ActionInsertFactCol52) {
            this.addInsert(baseColumn.getHeader(), ((ActionInsertFactCol52)baseColumn).getBoundName(), ((ActionInsertFactCol52)baseColumn).getFactType(), ((ActionInsertFactCol52)baseColumn).getFactField(), ((ActionInsertFactCol52)baseColumn).getType());
        } else if (baseColumn instanceof ActionWorkItemCol52) {
            this.addWorkItem((ActionWorkItemCol52)baseColumn);
        } else if (baseColumn instanceof ActionRetractFactCol52) {
            this.addRetract((ActionRetractFactCol52)baseColumn);
        }
    }

    public void addHeaderAndTitle(String title, String header) {
        this.headerRow.createCell(this.targetColumnIndex).setCellValue(title);
        this.headerTitleRow.createCell(this.targetColumnIndex).setCellValue(header);
    }

    private void addWorkItem(ActionWorkItemCol52 column) {
        PortableWorkDefinition workItemDefinition = column.getWorkItemDefinition();
        String wimManagerName = this.getWorkItemManagerVariableName(workItemDefinition.getName());
        String wiParamName = this.getWorkItemParameterVariableName(workItemDefinition.getName());
        StringBuilder builder = new StringBuilder();
        for (PortableParameterDefinition parameterDefinition : workItemDefinition.getParameters()) {
            builder.append(wiParamName);
            builder.append(".getParameters().put(");
            builder.append("\"");
            builder.append(parameterDefinition.getName());
            builder.append("\", ");
            builder.append(parameterDefinition.asString());
            builder.append(");\n");
        }
        String format = MessageFormat.format("org.drools.core.process.instance.WorkItemManager {0} = (org.drools.core.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();\norg.drools.core.process.instance.impl.WorkItemImpl {1} = new org.drools.core.process.instance.impl.WorkItemImpl();\n{1}.setName( \"{2}\" );\n{3}{0}.internalExecuteWorkItem( {1} );", wimManagerName, wiParamName, workItemDefinition.getName(), builder.toString());
        this.addHeaderAndTitle(ACTION, column.getHeader());
        this.fieldRow.createCell(this.targetColumnIndex).setCellValue(format);
    }

    private String getWorkItemParameterVariableName(String name) {
        return String.format("wi%sParameter", name);
    }

    private String getWorkItemManagerVariableName(String name) {
        return String.format("wi%sManager", name);
    }

    private void addRetract(ActionRetractFactCol52 column) {
        this.addHeaderAndTitle(ACTION, column.getHeader());
        this.fieldRow.createCell(this.targetColumnIndex).setCellValue("retract( $param );");
    }

    public boolean addInsert(String header, String boundName, String factType, String factField, String valueType) {
        boolean madeInsert = false;
        if (this.columnContext.isBoundNameFree(boundName)) {
            madeInsert = true;
            this.addHeaderAndTitle(ACTION, "");
            this.fieldRow.createCell(this.targetColumnIndex).setCellValue(MessageFormat.format("{0} {1} = new {2}(); insert( {1} );", factType, boundName, factType));
            this.columnContext.addBoundName(boundName);
            this.incrementTargetIndex();
        }
        this.addHeaderAndTitle(ACTION, header);
        this.fieldRow.createCell(this.targetColumnIndex).setCellValue(this.addSetMethod(boundName, factField, this.getRHSParamWithWrapper(valueType)));
        return madeInsert;
    }

    private String getRHSParamWithWrapper(String valueType) {
        switch (valueType) {
            case "BigDecimal": {
                return "new java.math.BigDecimal(\"$param\")";
            }
            case "BigInteger": {
                return "new java.math.BigInteger(\"$param\")";
            }
            case "Double": {
                return "$paramd";
            }
            case "Float": {
                return "$paramf";
            }
            case "Long": {
                return "$paramL";
            }
        }
        return "$param";
    }

    private String getLHSParamWithWrapper(String type) {
        switch (type) {
            case "BigDecimal": {
                return "$paramB";
            }
            case "BigInteger": {
                return "$paramI";
            }
        }
        return "$param";
    }

    private void addSetField(ActionSetFieldCol52 column) {
        this.addSetField(column, this.getRHSParamWithWrapper(column.getType()));
    }

    private void addWorkItemSetField(ActionWorkItemSetFieldCol52 column) {
        this.addSetField((ActionSetFieldCol52)column, String.format("(%s) %s.getResult( \"Result\" )", this.getColumnDataType(this.sourceColumnIndex), this.getWorkItemParameterVariableName(column.getWorkItemName())));
    }

    private void addSetField(ActionSetFieldCol52 column, String value) {
        this.addHeaderAndTitle(ACTION, column.getHeader());
        this.fieldRow.createCell(this.targetColumnIndex).setCellValue(this.addSetMethod(column.getBoundName(), column.getFactField(), value));
    }

    public void addCondition(ConditionCol52 column) {
        this.addHeaderAndTitle(CONDITION, column.getHeader());
        if (column.getConstraintValueType() == 5) {
            if (column.getFactField().contains("$param")) {
                this.fieldRow.createCell(this.targetColumnIndex).setCellValue(String.format("eval( %s )", column.getFactField()));
            } else {
                this.fieldRow.createCell(this.targetColumnIndex).setCellValue(String.format("eval( %s )", "$param"));
            }
        } else if (column.getBinding() == null || column.getBinding().trim().isEmpty()) {
            this.fieldRow.createCell(this.targetColumnIndex).setCellValue(String.format(this.getTemplate(column.getConstraintValueType(), column.getFieldType()), column.getFactField(), this.getOperator(column)));
        } else {
            this.fieldRow.createCell(this.targetColumnIndex).setCellValue(String.format(this.getTemplateWithBinds(column.getConstraintValueType()), column.getBinding(), column.getFactField(), this.getOperator(column)));
        }
    }

    private String getTemplate(int constraintValueType, String fieldType) {
        if (constraintValueType == 3) {
            return "%s %s ( " + this.getLHSParamWithWrapper(fieldType) + " )";
        }
        return "%s %s " + this.getLHSParamWithWrapper(fieldType);
    }

    private String getTemplateWithBinds(int constraintValueType) {
        if (constraintValueType == 3) {
            return "%s : %s %s ( $param )";
        }
        return "%s : %s %s $param";
    }

    private String getOperator(ConditionCol52 column) {
        if (Objects.equals("== null", column.getOperator())) {
            return "==";
        }
        if (Objects.equals("!= null", column.getOperator())) {
            return "!=";
        }
        return column.getOperator();
    }

    private void addAttribute(AttributeCol52 column) {
        if (Objects.equals(Attribute.NEGATE_RULE.getAttributeName(), column.getAttribute())) {
            throw new UnsupportedOperationException("Conversion of the negate attribute is not supported.");
        }
        this.headerRow.createCell(this.targetColumnIndex).setCellValue(this.getAttribute(column));
    }

    private String getAttribute(AttributeCol52 column) {
        if (Objects.equals(Attribute.SALIENCE.getAttributeName(), column.getAttribute())) {
            return "PRIORITY";
        }
        return column.getAttribute().toUpperCase();
    }

    private void addMetadata(MetadataCol52 column) {
        this.addHeaderAndTitle(METADATA, column.getHeader());
        this.fieldRow.createCell(this.targetColumnIndex).setCellValue(String.format("%s( $param )", column.getMetadata()));
    }

    private String addSetMethod(String boundName, String factField, String value) {
        return String.format("%s.set%s%s( %s );", boundName, factField.substring(0, 1).toUpperCase(), factField.substring(1), value);
    }

    private String getColumnDataType(int columnIndex) {
        return this.columnUtilities.getType((BaseColumn)this.dtable.getExpandedColumns().get(columnIndex));
    }
}

