/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion.util;

import org.drools.workbench.models.datamodel.rule.ActionFieldList;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;

public class BRLColumnUtil {
    private BRLColumnUtil() {
    }

    public static boolean canThisColumnBeSplitToMultiple(BRLActionColumn brlColumn) {
        for (IAction iAction : brlColumn.getDefinition()) {
            if (!BRLColumnUtil.onlyActionFieldListIsAccepted(iAction) && !BRLColumnUtil.validateActionFieldValues((ActionFieldList)iAction)) continue;
            return false;
        }
        return true;
    }

    public static boolean canThisColumnBeSplitToMultiple(BRLConditionColumn brlColumn) {
        for (IPattern iPattern : brlColumn.getDefinition()) {
            if (!BRLColumnUtil.onlyFactPatternsAreAccepted(iPattern) && !BRLColumnUtil.validateFactPatternConstraints(((FactPattern)iPattern).getConstraintList().getConstraints())) continue;
            return false;
        }
        return true;
    }

    private static boolean validateActionFieldValues(ActionFieldList iAction) {
        for (ActionFieldValue fieldValue : iAction.getFieldValues()) {
            if (!BRLColumnUtil.onlyAllowedActionFieldValueTypeIsTemplateType(fieldValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean validateFactPatternConstraints(FieldConstraint[] constraints) {
        for (FieldConstraint constraint : constraints) {
            if (BRLColumnUtil.acceptOnlySingleFieldConstraints(constraint)) {
                return true;
            }
            if (BRLColumnUtil.useOfExpressionsIsNotAllowed((SingleFieldConstraint)constraint)) {
                return true;
            }
            if (!BRLColumnUtil.onlyAllowedConstraintValueTypeIsTemplateType((SingleFieldConstraint)constraint)) continue;
            return true;
        }
        return false;
    }

    private static boolean onlyAllowedActionFieldValueTypeIsTemplateType(ActionFieldValue fieldValue) {
        return fieldValue.getNature() != 7;
    }

    private static boolean onlyActionFieldListIsAccepted(IAction iAction) {
        return !(iAction instanceof ActionFieldList);
    }

    private static boolean onlyFactPatternsAreAccepted(IPattern iPattern) {
        return !(iPattern instanceof FactPattern);
    }

    private static boolean onlyAllowedConstraintValueTypeIsTemplateType(SingleFieldConstraint fieldConstraint) {
        return fieldConstraint.getConstraintValueType() != 7;
    }

    private static boolean useOfExpressionsIsNotAllowed(SingleFieldConstraint fieldConstraint) {
        return !fieldConstraint.getExpressionValue().isEmpty();
    }

    private static boolean acceptOnlySingleFieldConstraints(FieldConstraint constraint) {
        return !(constraint instanceof SingleFieldConstraint);
    }
}

