/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.driver.impl;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.soup.project.datamodel.oracle.TypeSource;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationContext;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationEngine;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationListener;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.ObjectSource;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.ModelFactoryImpl;
import org.kie.workbench.common.services.datamodeller.driver.AnnotationDriver;
import org.kie.workbench.common.services.datamodeller.driver.FileChangeDescriptor;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriver;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverException;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverListener;
import org.kie.workbench.common.services.datamodeller.driver.impl.DefaultDataModelOracleAnnotationDriver;
import org.kie.workbench.common.services.datamodeller.driver.impl.annotations.CommonAnnotations;
import org.kie.workbench.common.services.datamodeller.driver.model.ModelDriverResult;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.datamodeller.util.NamingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public class DataModelOracleModelDriver
implements ModelDriver {
    private static final Logger logger = LoggerFactory.getLogger(DataModelOracleModelDriver.class);
    private List<AnnotationDefinition> configuredAnnotations = new ArrayList<AnnotationDefinition>();
    private Map<String, AnnotationDriver> annotationDrivers = new HashMap<String, AnnotationDriver>();
    private ModuleDataModelOracle oracleDataModel;
    private ClassLoader moduleClassLoader;

    public static DataModelOracleModelDriver getInstance() {
        return new DataModelOracleModelDriver();
    }

    public static DataModelOracleModelDriver getInstance(ModuleDataModelOracle oracleDataModel, ClassLoader moduleClassLoader) {
        return new DataModelOracleModelDriver(oracleDataModel, moduleClassLoader);
    }

    protected DataModelOracleModelDriver(ModuleDataModelOracle oracleDataModel, ClassLoader moduleClassLoader) {
        this();
        this.oracleDataModel = oracleDataModel;
        this.moduleClassLoader = moduleClassLoader;
    }

    protected DataModelOracleModelDriver() {
        this.configuredAnnotations.addAll(CommonAnnotations.getCommonAnnotations());
        for (AnnotationDefinition annotationDefinition : this.configuredAnnotations) {
            this.annotationDrivers.put(annotationDefinition.getClassName(), new DefaultDataModelOracleAnnotationDriver());
        }
    }

    @Override
    public List<AnnotationDefinition> getConfiguredAnnotations() {
        return this.configuredAnnotations;
    }

    @Override
    public AnnotationDefinition getConfiguredAnnotation(String annotationClassName) {
        for (AnnotationDefinition annotationDefinition : this.configuredAnnotations) {
            if (!annotationClassName.equals(annotationDefinition.getClassName())) continue;
            return annotationDefinition;
        }
        return null;
    }

    @Override
    public AnnotationDriver getAnnotationDriver(String annotationClassName) {
        return this.annotationDrivers.get(annotationClassName);
    }

    @Override
    public void generateModel(DataModel dataModel, ModelDriverListener generationListener) throws Exception {
        GenerationContext generationContext = new GenerationContext(dataModel);
        generationContext.setGenerationListener(generationListener);
        GenerationEngine generationEngine = GenerationEngine.getInstance();
        generationEngine.generate(generationContext);
    }

    @Override
    public DataModel createModel() {
        return ModelFactoryImpl.getInstance().newModel();
    }

    @Override
    public ModelDriverResult loadModel() throws ModelDriverException {
        ModelDriverResult result = new ModelDriverResult();
        result.setDataModel(this.loadModel(this.oracleDataModel, this.moduleClassLoader));
        return result;
    }

    public DataModel loadModel(ModuleDataModelOracle oracleDataModel, ClassLoader moduleClassLoader) throws ModelDriverException {
        DataModel dataModel = this.createModel();
        logger.debug("Adding oracleDataModel: " + oracleDataModel + " to dataModel: " + dataModel);
        String[] factTypes = DataModelOracleUtilities.getFactTypes((ModuleDataModelOracle)oracleDataModel);
        ObjectSource source = null;
        if (factTypes != null && factTypes.length > 0) {
            for (int i = 0; i < factTypes.length; ++i) {
                source = this.factSource(oracleDataModel, factTypes[i]);
                if (source == null || !ObjectSource.INTERNAL.equals((Object)source) && !ObjectSource.DEPENDENCY.equals((Object)source)) continue;
                this.addFactType(dataModel, oracleDataModel, factTypes[i], source, moduleClassLoader);
            }
        } else {
            logger.debug("oracleDataModel hasn't defined fact types");
        }
        return dataModel;
    }

    private void addFactType(DataModel dataModel, ModuleDataModelOracle oracleDataModel, String factType, ObjectSource source, ClassLoader classLoader) throws ModelDriverException {
        String packageName = NamingUtils.extractPackageName(factType);
        String className = NamingUtils.extractClassName(factType);
        String superClass = DataModelOracleUtilities.getSuperType((ModuleDataModelOracle)oracleDataModel, (String)factType);
        logger.debug("Adding factType: " + factType + ", to dataModel: " + dataModel + ", from oracleDataModel: " + oracleDataModel);
        ClassMetadata classMetadata = this.readClassMetadata(factType, classLoader);
        if (!(classMetadata == null || classMetadata.isMemberClass() || classMetadata.isAnonymousClass() || classMetadata.isLocalClass())) {
            Map fields;
            Visibility visibility = DriverUtils.buildVisibility(classMetadata.getModifiers());
            DataObject dataObject = dataModel.addDataObject(factType, visibility, Modifier.isAbstract(classMetadata.getModifiers()), Modifier.isFinal(classMetadata.getModifiers()), source);
            dataObject.setSuperClassName(superClass);
            Set typeAnnotations = DataModelOracleUtilities.getTypeAnnotations((ModuleDataModelOracle)oracleDataModel, (String)factType);
            if (typeAnnotations != null) {
                for (org.kie.soup.project.datamodel.oracle.Annotation annotation : typeAnnotations) {
                    this.addFactTypeAnnotation(dataObject, annotation);
                }
            }
            if ((fields = oracleDataModel.getModuleModelFields()) != null) {
                ModelField[] factFields = (ModelField[])fields.get(factType);
                Map typeFieldsAnnotations = DataModelOracleUtilities.getTypeFieldsAnnotations((ModuleDataModelOracle)oracleDataModel, (String)factType);
                if (factFields != null && factFields.length > 0) {
                    for (int j = 0; j < factFields.length; ++j) {
                        Set fieldAnnotations;
                        ObjectProperty property;
                        ModelField field = factFields[j];
                        if (!this.isLoadableField(field)) continue;
                        if (field.getType().equals("Collection")) {
                            String bag = DataModelOracleUtilities.getFieldClassName((ModuleDataModelOracle)oracleDataModel, (String)factType, (String)field.getName());
                            String itemsClass = DataModelOracleUtilities.getParametricFieldType((ModuleDataModelOracle)oracleDataModel, (String)factType, (String)field.getName());
                            property = itemsClass == null ? dataObject.addProperty(field.getName(), bag) : dataObject.addProperty(field.getName(), itemsClass, true, bag);
                        } else {
                            property = dataObject.addProperty(field.getName(), this.getFieldType(oracleDataModel, packageName, field.getClassName()));
                        }
                        if (typeFieldsAnnotations == null || (fieldAnnotations = (Set)typeFieldsAnnotations.get(field.getName())) == null) continue;
                        for (org.kie.soup.project.datamodel.oracle.Annotation fieldAnnotation : fieldAnnotations) {
                            this.addFieldAnnotation(dataObject, property, fieldAnnotation);
                        }
                    }
                }
            } else {
                logger.debug("No fields for factTye: " + factType);
            }
        }
    }

    private ClassMetadata readClassMetadata(String factType, ClassLoader classLoader) {
        try {
            Class<?> _class = classLoader.loadClass(factType);
            return new ClassMetadata(_class.getModifiers(), _class.isMemberClass(), _class.isLocalClass(), _class.isAnonymousClass());
        }
        catch (ClassNotFoundException e) {
            logger.error("It was not possible to read class metadata for class: " + factType);
            return null;
        }
    }

    private void addFactTypeAnnotation(DataObject dataObject, org.kie.soup.project.datamodel.oracle.Annotation annotationToken) throws ModelDriverException {
        Annotation annotation = this.createAnnotation(annotationToken);
        if (annotation != null) {
            dataObject.addAnnotation(annotation);
        }
    }

    private void addFieldAnnotation(DataObject dataObject, ObjectProperty property, org.kie.soup.project.datamodel.oracle.Annotation annotationToken) throws ModelDriverException {
        Annotation annotation = this.createAnnotation(annotationToken);
        if (annotation != null) {
            property.addAnnotation(annotation);
        }
    }

    private Annotation createAnnotation(org.kie.soup.project.datamodel.oracle.Annotation annotationToken) throws ModelDriverException {
        AnnotationDefinition annotationDefinition = this.getConfiguredAnnotation(annotationToken.getQualifiedTypeName());
        Annotation annotation = null;
        if (annotationDefinition != null) {
            AnnotationDriver annotationDriver = this.getAnnotationDriver(annotationDefinition.getClassName());
            if (annotationDriver != null) {
                annotation = annotationDriver.buildAnnotation(annotationDefinition, annotationToken);
            } else {
                logger.warn("AnnotationDriver for annotation: " + annotationToken.getQualifiedTypeName() + " is not configured for this driver");
            }
        } else {
            logger.warn("Annotation: " + annotationToken.getQualifiedTypeName() + " is not configured for this driver.");
        }
        return annotation;
    }

    private String getFieldType(ModuleDataModelOracle oracleDataModel, String packageName, String fieldType) {
        return fieldType;
    }

    private ObjectSource factSource(ModuleDataModelOracle oracleDataModel, String factType) {
        TypeSource oracleType = DataModelOracleUtilities.getTypeSource((ModuleDataModelOracle)oracleDataModel, (String)factType);
        if (TypeSource.JAVA_PROJECT.equals((Object)oracleType)) {
            return ObjectSource.INTERNAL;
        }
        if (TypeSource.JAVA_DEPENDENCY.equals((Object)oracleType)) {
            return ObjectSource.DEPENDENCY;
        }
        return null;
    }

    private boolean isLoadableField(ModelField field) {
        return field.getOrigin().equals((Object)ModelField.FIELD_ORIGIN.DECLARED);
    }

    public class ClassMetadata {
        int modifiers;
        boolean memberClass;
        boolean localClass;
        boolean anonymousClass;

        public ClassMetadata(int modifiers, boolean memberClass, boolean localClass, boolean anonymousClass) {
            this.modifiers = modifiers;
            this.memberClass = memberClass;
            this.localClass = localClass;
            this.anonymousClass = anonymousClass;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public void setModifiers(int modifiers) {
            this.modifiers = modifiers;
        }

        public boolean isMemberClass() {
            return this.memberClass;
        }

        public void setMemberClass(boolean memberClass) {
            this.memberClass = memberClass;
        }

        public boolean isLocalClass() {
            return this.localClass;
        }

        public void setLocalClass(boolean localClass) {
            this.localClass = localClass;
        }

        public boolean isAnonymousClass() {
            return this.anonymousClass;
        }

        public void setAnonymousClass(boolean anonymousClass) {
            this.anonymousClass = anonymousClass;
        }
    }

    static class OracleGenerationListener
    implements GenerationListener {
        Path output;
        IOService ioService;
        OpenOption option;
        List<FileChangeDescriptor> fileChanges = new ArrayList<FileChangeDescriptor>();

        public OracleGenerationListener(IOService ioService, Path output, OpenOption option) {
            this.ioService = ioService;
            this.output = output;
            this.option = option;
        }

        @Override
        public void assetGenerated(String fileName, String content) {
            Path subDirPath = this.output;
            int index = fileName.lastIndexOf("/");
            if (index == 0) {
                fileName = fileName.substring(1, fileName.length());
            } else if (index > 0) {
                String dirNamesPath = fileName.substring(0, index);
                fileName = fileName.substring(index + 1, fileName.length());
                StringTokenizer dirNames = new StringTokenizer(dirNamesPath, "/");
                while (dirNames.hasMoreElements()) {
                    String subDir = dirNames.nextToken();
                    if (this.ioService.exists(subDirPath = subDirPath.resolve(subDir))) continue;
                    this.ioService.createDirectory(subDirPath, new FileAttribute[0]);
                }
            }
            Path destFilePath = subDirPath.resolve(fileName);
            boolean exists = this.ioService.exists(destFilePath);
            this.ioService.write(destFilePath, content, new OpenOption[]{this.option});
            if (!exists) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Genertion listener created a new file: " + destFilePath);
                }
                this.fileChanges.add(new FileChangeDescriptor(destFilePath, 0));
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Generation listener modified file: " + destFilePath);
                }
                this.fileChanges.add(new FileChangeDescriptor(destFilePath, 2));
            }
        }

        public List<FileChangeDescriptor> getFileChanges() {
            return this.fileChanges;
        }
    }
}

