/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.parser.descr;

import java.util.ArrayList;
import java.util.List;
import org.kie.workbench.common.services.datamodeller.parser.descr.AnnotationDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.ElementDescriptor;
import org.kie.workbench.common.services.datamodeller.parser.descr.ModifierDescr;

public class ModifierListDescr
extends ElementDescriptor {
    public ModifierListDescr() {
        super(ElementDescriptor.ElementType.MODIFIER_LIST);
    }

    public ModifierListDescr(String text, int start, int line, int position) {
        this(text, start, -1, line, position);
    }

    public ModifierListDescr(String text, int start, int stop) {
        this(text, start, stop, -1, -1);
    }

    public ModifierListDescr(String text, int start, int stop, int line, int position) {
        super(ElementDescriptor.ElementType.MODIFIER_LIST, text, start, stop, line, position);
    }

    public void add(ModifierDescr modifierDescr) {
        this.getElements().add(modifierDescr);
    }

    public void add(AnnotationDescr annotationDescr) {
        this.getElements().add(annotationDescr);
    }

    public int size() {
        List<ElementDescriptor> modifiers = this.getAllModifiers();
        return modifiers != null ? modifiers.size() : 0;
    }

    public List<ModifierDescr> getModifiers() {
        ArrayList<ModifierDescr> modifiers = new ArrayList<ModifierDescr>();
        for (ElementDescriptor modifier : this.getElements().getElementsByType(ElementDescriptor.ElementType.MODIFIER)) {
            modifiers.add((ModifierDescr)modifier);
        }
        return modifiers;
    }

    public List<AnnotationDescr> getAnnotations() {
        ArrayList<AnnotationDescr> modifiers = new ArrayList<AnnotationDescr>();
        for (ElementDescriptor modifier : this.getElements().getElementsByType(ElementDescriptor.ElementType.ANNOTATION)) {
            modifiers.add((AnnotationDescr)modifier);
        }
        return modifiers;
    }

    public List<ElementDescriptor> getAllModifiers() {
        ArrayList<ElementDescriptor> modifiers = new ArrayList<ElementDescriptor>();
        for (ElementDescriptor modifier : this.getElements()) {
            if (ElementDescriptor.ElementType.MODIFIER != modifier.getElementType() && ElementDescriptor.ElementType.ANNOTATION != modifier.getElementType()) continue;
            modifiers.add(modifier);
        }
        return modifiers;
    }
}

