/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.client.history;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import java.util.Collections;
import java.util.List;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.history.VersionHistoryPresenterView;
import org.uberfire.ext.editor.commons.client.history.event.VersionSelectedEvent;
import org.uberfire.ext.editor.commons.version.VersionService;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.mvp.ParameterizedCommand;

public class VersionHistoryPresenter
implements VersionHistoryPresenterView.Presenter,
IsWidget {
    private VersionHistoryPresenterView view;
    private Caller<VersionService> versionService;
    private AsyncDataProvider<VersionRecord> dataProvider;
    private Event<VersionSelectedEvent> versionSelectedEvent;
    private Path path;
    private String version;
    private List<VersionRecord> records;
    private ParameterizedCommand<VersionRecord> onCurrentVersionRefreshed;

    @Inject
    public VersionHistoryPresenter(VersionHistoryPresenterView view, Caller<VersionService> versionService, Event<VersionSelectedEvent> versionSelectedEvent) {
        this.view = view;
        this.versionService = versionService;
        this.versionSelectedEvent = versionSelectedEvent;
        view.setPresenter(this);
        this.dataProvider = new AsyncDataProvider<VersionRecord>(){

            protected void onRangeChanged(HasData<VersionRecord> display) {
                if (VersionHistoryPresenter.this.records != null) {
                    this.updateRowCount(VersionHistoryPresenter.this.records.size(), true);
                    this.updateRowData(0, VersionHistoryPresenter.this.records);
                }
            }
        };
    }

    public void init(Path path) {
        this.path = path;
    }

    private void loadContent() {
        ((VersionService)this.versionService.call(this.getRemoteCallback())).getVersions(this.path);
    }

    private RemoteCallback<List<VersionRecord>> getRemoteCallback() {
        return new RemoteCallback<List<VersionRecord>>(){

            public void callback(List<VersionRecord> records) {
                VersionHistoryPresenter.this.view.setup(VersionHistoryPresenter.this.version, (AsyncDataProvider<VersionRecord>)VersionHistoryPresenter.this.dataProvider);
                Collections.reverse(records);
                VersionHistoryPresenter.this.records = records;
                VersionHistoryPresenter.this.view.refreshGrid();
                VersionHistoryPresenter.this.doOnCurrentVersionRefreshed(VersionHistoryPresenter.this.version);
            }
        };
    }

    @Override
    public void onSelect(VersionRecord record) {
        if (!record.id().equals(this.version)) {
            this.view.showLoading();
            this.versionSelectedEvent.fire((Object)new VersionSelectedEvent(this.path, record));
        }
    }

    public void onVersionChange(@Observes VersionSelectedEvent event) {
        if (this.path != null && this.path.toURI().equals(event.getPathToFile().toURI())) {
            this.version = event.getVersionRecord().id();
            this.loadContent();
        }
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void refresh(String version) {
        this.version = version;
        this.loadContent();
    }

    public void setOnCurrentVersionRefreshed(ParameterizedCommand<VersionRecord> onCurrentVersionRefreshed) {
        this.onCurrentVersionRefreshed = onCurrentVersionRefreshed;
    }

    private void doOnCurrentVersionRefreshed(String version) {
        if (this.onCurrentVersionRefreshed != null && this.records != null && version != null) {
            for (VersionRecord record : this.records) {
                if (!version.equals(record.id())) continue;
                this.onCurrentVersionRefreshed.execute((Object)record);
                break;
            }
        }
    }
}

